/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.state;

import java.util.HashMap;
import org.apache.flink.streaming.state.MapState;
import org.apache.flink.streaming.state.OperatorState;
import org.apache.flink.streaming.state.checkpoint.MapCheckpoint;
import org.apache.flink.streaming.state.checkpoint.StateCheckpoint;
import org.junit.Assert;
import org.junit.Test;

public class MapStateTest {
    @Test
    public void testMapState() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        map.remove("a");
        MapState mapState = new MapState();
        mapState.put((Object)"a", (Object)1);
        mapState.put((Object)"b", (Object)2);
        mapState.put((Object)"c", (Object)3);
        Assert.assertEquals((long)1L, (long)((Integer)mapState.remove((Object)"a")).intValue());
        Assert.assertEquals(null, (Object)mapState.remove((Object)"a"));
        Assert.assertEquals((long)2L, (long)mapState.size());
        Assert.assertEquals(map, (Object)mapState.state);
        Assert.assertEquals(map.entrySet(), (Object)mapState.entrySet());
        Assert.assertTrue((boolean)mapState.containsKey((Object)"b"));
        Assert.assertFalse((boolean)mapState.containsKey((Object)"a"));
        Assert.assertEquals((long)2L, (long)mapState.updatedItems.size());
        Assert.assertEquals((long)1L, (long)mapState.removedItems.size());
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("a", 0);
        map2.put("e", -1);
        mapState.putAll(map2);
        Assert.assertEquals((long)4L, (long)mapState.updatedItems.size());
        Assert.assertEquals((long)0L, (long)mapState.removedItems.size());
        mapState.clear();
        Assert.assertEquals(new HashMap(), (Object)mapState.state);
        Assert.assertTrue((boolean)mapState.clear);
        Assert.assertEquals((long)0L, (long)mapState.updatedItems.size());
        Assert.assertEquals((long)0L, (long)mapState.removedItems.size());
        mapState.putAll(map);
        Assert.assertEquals(map.keySet(), (Object)mapState.updatedItems);
    }

    @Test
    public void testMapStateCheckpointing() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        MapState mapState = new MapState();
        mapState.putAll(map);
        StateCheckpoint mcp = mapState.checkpoint();
        Assert.assertEquals(map, (Object)mcp.getCheckpointedState());
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("a", 0);
        map2.put("e", -1);
        mapState.put((Object)"a", (Object)0);
        mapState.put((Object)"e", (Object)-1);
        mapState.remove((Object)"b");
        MapCheckpoint mcp2 = new MapCheckpoint((OperatorState)mapState);
        Assert.assertEquals(map2, (Object)mcp2.getCheckpointedState());
        mcp.update((StateCheckpoint)mcp2);
        Assert.assertEquals((Object)mapState.state, (Object)mcp.getCheckpointedState());
        mapState.clear();
        mapState.put((Object)"a", (Object)1);
        mapState.put((Object)"a", (Object)2);
        mapState.put((Object)"b", (Object)-3);
        mapState.put((Object)"c", (Object)0);
        mapState.remove((Object)"b");
        mcp.update(mapState.checkpoint());
        Assert.assertEquals((Object)mapState.state, (Object)mcp.getCheckpointedState());
        MapState mapState2 = (MapState)new MapState().restore(mcp);
        Assert.assertTrue((boolean)mapState2.stateEquals((OperatorState)mapState));
        mapState2.reBuild(mapState2.repartition(10));
        Assert.assertTrue((boolean)mapState2.stateEquals((OperatorState)mapState));
        MapState mapState3 = new MapState();
        mapState3.put((Object)1, (Object)1);
        mapState3.put((Object)2, (Object)1);
        mapState3.reBuild(new OperatorState[]{mapState3.repartition(2)[0]});
        Assert.assertTrue((boolean)mapState3.containsKey((Object)2));
        Assert.assertFalse((boolean)mapState3.containsKey((Object)1));
    }
}

