/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.partitioner;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.partitioner.FieldsPartitioner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldsPartitionerTest {
    private FieldsPartitioner<Tuple> fieldsPartitioner;
    private StreamRecord<Tuple> streamRecord1 = new StreamRecord().setObject((Object)new Tuple2((Object)"test", (Object)0));
    private StreamRecord<Tuple> streamRecord2 = new StreamRecord().setObject((Object)new Tuple2((Object)"test", (Object)42));
    private SerializationDelegate<StreamRecord<Tuple>> sd1 = new SerializationDelegate(null);
    private SerializationDelegate<StreamRecord<Tuple>> sd2 = new SerializationDelegate(null);

    @Before
    public void setPartitioner() {
        this.fieldsPartitioner = new FieldsPartitioner((KeySelector)new KeySelector<Tuple, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple value) throws Exception {
                return (String)value.getField(0);
            }
        });
    }

    @Test
    public void testSelectChannelsLength() {
        this.sd1.setInstance(this.streamRecord1);
        Assert.assertEquals((long)1L, (long)this.fieldsPartitioner.selectChannels(this.sd1, 1).length);
        Assert.assertEquals((long)1L, (long)this.fieldsPartitioner.selectChannels(this.sd1, 2).length);
        Assert.assertEquals((long)1L, (long)this.fieldsPartitioner.selectChannels(this.sd1, 1024).length);
    }

    @Test
    public void testSelectChannelsGrouping() {
        this.sd1.setInstance(this.streamRecord1);
        this.sd2.setInstance(this.streamRecord2);
        Assert.assertArrayEquals((int[])this.fieldsPartitioner.selectChannels(this.sd1, 1), (int[])this.fieldsPartitioner.selectChannels(this.sd2, 1));
        Assert.assertArrayEquals((int[])this.fieldsPartitioner.selectChannels(this.sd1, 2), (int[])this.fieldsPartitioner.selectChannels(this.sd2, 2));
        Assert.assertArrayEquals((int[])this.fieldsPartitioner.selectChannels(this.sd1, 1024), (int[])this.fieldsPartitioner.selectChannels(this.sd2, 1024));
    }
}

