/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import org.apache.flink.streaming.api.windowing.helper.Timestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.api.windowing.policy.TimeTriggerPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TimeTriggerPolicyTest {
    @Test
    public void timeTriggerRegularNotifyTest() {
        Integer[] times = new Integer[]{1, 3, 4, 6, 7, 9, 14, 20, 21, 22, 30};
        Timestamp<Integer> timeStamp = new Timestamp<Integer>(){

            public long getTimestamp(Integer value) {
                return value.intValue();
            }
        };
        for (long granularity = 0L; granularity < 31L; ++granularity) {
            TimeTriggerPolicy policy = new TimeTriggerPolicy(granularity, new TimestampWrapper((Timestamp)timeStamp, 0L));
            long currentTime = 0L;
            for (int i = 0; i < times.length; ++i) {
                boolean result = policy.notifyTrigger((Object)times[i]);
                if ((long)times[i].intValue() >= currentTime + granularity) {
                    if (granularity != 0L) {
                        currentTime = (long)times[i].intValue() - ((long)times[i].intValue() - currentTime) % granularity;
                    }
                    Assert.assertTrue((String)("The policy did not trigger at pos " + i + " (current time border: " + currentTime + "; current granularity: " + granularity + "; data point time: " + times[i] + ")"), (boolean)result);
                    continue;
                }
                Assert.assertFalse((String)("The policy triggered wrong at pos " + i + " (current time border: " + currentTime + "; current granularity: " + granularity + "; data point time: " + times[i] + ")"), (boolean)result);
            }
        }
    }

    @Test
    public void timeTriggerPreNotifyTest() {
        Integer[] times = new Integer[]{1, 3, 20, 26};
        Timestamp<Integer> timeStamp = new Timestamp<Integer>(){

            public long getTimestamp(Integer value) {
                return value.intValue();
            }
        };
        TimeTriggerPolicy policy = new TimeTriggerPolicy(5L, new TimestampWrapper((Timestamp)timeStamp, 0L));
        Long[][] result = new Long[][]{new Long[0], new Long[0], {4L, 9L, 14L, 19L}, {24L}};
        for (int i = 0; i < times.length; ++i) {
            this.arrayEqualityCheck(result[i], policy.preNotifyTrigger((Object)times[i]));
            policy.notifyTrigger((Object)times[i]);
        }
    }

    private void arrayEqualityCheck(Object[] array1, Object[] array2) {
        Assert.assertEquals((String)"The result arrays must have the same length", (long)array1.length, (long)array2.length);
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((String)("Unequal fields at position " + i), (Object)array1[i], (Object)array2[i]);
        }
    }
}

