/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.LinkedList;
import org.apache.flink.streaming.api.windowing.helper.Timestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.api.windowing.policy.TimeEvictionPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TimeEvictionPolicyTest {
    @Test
    public void timeEvictionTest() {
        Integer[] times = new Integer[]{1, 3, 4, 6, 7, 9, 14, 20, 21, 22, 30, 31, 33, 36, 40, 41, 42, 43, 44, 45, 47, 55};
        Integer[] numToDelete = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 3};
        Timestamp<Integer> timeStamp = new Timestamp<Integer>(){

            public long getTimestamp(Integer value) {
                return value.intValue();
            }
        };
        for (long granularity = 0L; granularity < 40L; ++granularity) {
            TimeEvictionPolicy policy = new TimeEvictionPolicy(granularity, new TimestampWrapper((Timestamp)timeStamp, 0L));
            boolean triggered = false;
            int fakeAndRealCounter = 0;
            boolean fake = false;
            LinkedList<Integer> buffer = new LinkedList<Integer>();
            for (int i = 0; i < times.length; ++i) {
                int result;
                if (++fakeAndRealCounter > 2) {
                    fake = !fake;
                    fakeAndRealCounter = 0;
                }
                if (fake) {
                    result = policy.notifyEvictionWithFakeElement((Object)times[i], buffer.size());
                } else {
                    triggered = !triggered;
                    result = policy.notifyEviction((Object)times[i], triggered, buffer.size());
                }
                while (result > 0 && !buffer.isEmpty()) {
                    if ((long)((Integer)buffer.getFirst()).intValue() <= (long)times[i].intValue() - granularity) {
                        buffer.removeFirst();
                    } else {
                        Assert.fail((String)("The policy wanted to evict time " + buffer.getFirst() + " while the current time was " + times[i] + "and the granularity was " + granularity));
                    }
                    --result;
                }
                if (!buffer.isEmpty()) {
                    Assert.assertTrue((String)("The policy did not evict " + buffer.getFirst() + " while the current time was " + times[i] + " and the granularity was " + granularity), ((long)((Integer)buffer.getFirst()).intValue() >= (long)times[i].intValue() - granularity ? 1 : 0) != 0);
                }
                for (int j = numToDelete[i % numToDelete.length].intValue(); j > 0; --j) {
                    if (buffer.isEmpty()) continue;
                    buffer.removeFirst();
                }
                if (fake) continue;
                buffer.add(times[i]);
            }
        }
    }
}

