/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.extractor.Extractor;
import org.apache.flink.streaming.api.windowing.extractor.FieldFromTuple;
import org.apache.flink.streaming.api.windowing.policy.PunctuationPolicy;
import org.junit.Assert;
import org.junit.Test;

public class PunctuationPolicyTest {
    private boolean triggered = false;

    @Test
    public void PunctuationTriggerTestWithoutExtraction() {
        PunctuationPolicy policy = new PunctuationPolicy((Object)new TestObject(0));
        Assert.assertTrue((String)"The present punctuation was not detected. (POS 1)", (boolean)policy.notifyTrigger((Object)new TestObject(0)));
        Assert.assertFalse((String)"There was a punctuation detected which wasn't present. (POS 2)", (boolean)policy.notifyTrigger((Object)new TestObject(1)));
    }

    @Test
    public void PunctuationTriggerTestWithExtraction() {
        PunctuationPolicy policy = new PunctuationPolicy((Object)new TestObject(0), (Extractor)new FieldFromTuple(0));
        Assert.assertTrue((String)"The present punctuation was not detected. (POS 3)", (boolean)policy.notifyTrigger((Object)new Tuple2((Object)new TestObject(0), (Object)new TestObject(1))));
        Assert.assertFalse((String)"There was a punctuation detected which wasn't present. (POS 4)", (boolean)policy.notifyTrigger((Object)new Tuple2((Object)new TestObject(1), (Object)new TestObject(0))));
    }

    @Test
    public void PunctuationEvictionTestWithoutExtraction() {
        PunctuationPolicy policy = new PunctuationPolicy((Object)new TestObject(0));
        this.triggered = !this.triggered;
        Assert.assertEquals((String)"The present punctuation was not detected or the number of deleted tuples was wrong. (POS 5)", (long)0L, (long)policy.notifyEviction((Object)new TestObject(0), this.triggered, 0));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < i; ++j) {
                this.triggered = !this.triggered;
                Assert.assertEquals((String)"There was a punctuation detected which wasn't present. (POS 6)", (long)0L, (long)policy.notifyEviction((Object)new TestObject(1), this.triggered, 0));
            }
            this.triggered = !this.triggered;
            Assert.assertEquals((String)"The present punctuation was not detected or the number of deleted tuples was wrong. (POS 7)", (long)(i + 1), (long)policy.notifyEviction((Object)new TestObject(0), this.triggered, 0));
        }
    }

    @Test
    public void PunctuationEvictionTestWithExtraction() {
        PunctuationPolicy policy = new PunctuationPolicy((Object)new TestObject(0), (Extractor)new FieldFromTuple(0));
        this.triggered = !this.triggered;
        Assert.assertEquals((String)"The present punctuation was not detected or the number of deleted tuples was wrong. (POS 10)", (long)0L, (long)policy.notifyEviction((Object)new Tuple2((Object)new TestObject(0), (Object)new TestObject(1)), this.triggered, 0));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < i; ++j) {
                this.triggered = !this.triggered;
                Assert.assertEquals((String)"There was a punctuation detected which wasn't present. (POS 9)", (long)0L, (long)policy.notifyEviction((Object)new Tuple2((Object)new TestObject(1), (Object)new TestObject(0)), this.triggered, 0));
            }
            this.triggered = !this.triggered;
            Assert.assertEquals((String)"The present punctuation was not detected or the number of deleted tuples was wrong. (POS 10)", (long)(i + 1), (long)policy.notifyEviction((Object)new Tuple2((Object)new TestObject(0), (Object)new TestObject(1)), this.triggered, 0));
        }
    }

    private class TestObject {
        private int id;

        public TestObject(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            return o instanceof TestObject && ((TestObject)o).getId() == this.id;
        }

        public int getId() {
            return this.id;
        }
    }
}

