/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.deltafunction.DeltaFunction;
import org.apache.flink.streaming.api.windowing.policy.DeltaPolicy;
import org.junit.Assert;
import org.junit.Test;

public class DeltaPolicyTest {
    @Test
    public void testDelta() {
        DeltaPolicy deltaPolicy = new DeltaPolicy((DeltaFunction)new DeltaFunction<Tuple2<Integer, Integer>>(){

            public double getDelta(Tuple2<Integer, Integer> oldDataPoint, Tuple2<Integer, Integer> newDataPoint) {
                return (double)((Integer)newDataPoint.f0).intValue() - (double)((Integer)oldDataPoint.f0).intValue();
            }
        }, (Object)new Tuple2((Object)0, (Object)0), 2.0);
        List<Tuple2> tuples = Arrays.asList(new Tuple2((Object)1, (Object)0), new Tuple2((Object)2, (Object)0), new Tuple2((Object)3, (Object)0), new Tuple2((Object)6, (Object)0));
        Assert.assertFalse((boolean)deltaPolicy.notifyTrigger((Object)tuples.get(0)));
        Assert.assertEquals((long)0L, (long)deltaPolicy.notifyEviction((Object)tuples.get(0), false, 0));
        Assert.assertFalse((boolean)deltaPolicy.notifyTrigger((Object)tuples.get(1)));
        Assert.assertEquals((long)0L, (long)deltaPolicy.notifyEviction((Object)tuples.get(1), false, 1));
        Assert.assertTrue((boolean)deltaPolicy.notifyTrigger((Object)tuples.get(2)));
        Assert.assertEquals((long)1L, (long)deltaPolicy.notifyEviction((Object)tuples.get(2), true, 2));
        Assert.assertTrue((boolean)deltaPolicy.notifyTrigger((Object)tuples.get(3)));
        Assert.assertEquals((long)2L, (long)deltaPolicy.notifyEviction((Object)tuples.get(3), true, 2));
    }
}

