/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.policy.CountTriggerPolicy;
import org.apache.flink.streaming.api.windowing.policy.TriggerPolicy;
import org.junit.Assert;
import org.junit.Test;

public class CountTriggerPolicyTest {
    @Test
    public void testCountTriggerPolicy() {
        List<Integer> tuples = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        for (int i = 0; i < 10; ++i) {
            int j;
            TriggerPolicy triggerPolicy = Count.of((int)i).toTrigger();
            int counter = 0;
            for (j = 0; j < i; ++j) {
                Assert.assertFalse((String)("Triggerpolicy with count of " + i + " triggered at add nr. " + ++counter + ". It should not trigger for the first " + i + " adds."), (boolean)triggerPolicy.notifyTrigger((Object)tuples.get(j)));
            }
            for (j = 0; j < 3; ++j) {
                Assert.assertTrue((String)("Triggerpolicy with count of " + i + " did not trigger at the expected pos " + ++counter + "."), (boolean)triggerPolicy.notifyTrigger((Object)tuples.get(j)));
                for (int k = 0; k < i - 1; ++k) {
                    Assert.assertFalse((String)("Triggerpolicy with count of " + i + " triggered at add nr. " + ++counter), (boolean)triggerPolicy.notifyTrigger((Object)tuples.get(k)));
                }
            }
        }
    }

    @Test
    public void testCountTriggerPolicyStartValues() {
        List<Integer> tuples = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        for (int i = 0; i < 10; ++i) {
            int j = -5;
            while (i < 6) {
                CountTriggerPolicy triggerPolicy = new CountTriggerPolicy(i, j);
                for (int k = 0; k < (i - j > 0 ? i - j : 0); ++k) {
                    Assert.assertFalse((String)("Triggerpolicy with count of " + i + " and start value of " + j + " triggered at add nr. " + (k + 1)), (boolean)triggerPolicy.notifyTrigger((Object)tuples.get(k % 10)));
                }
                Assert.assertTrue((String)("Triggerpolicy with count of " + i + "and start value of " + j + " did not trigger at the expected position."), (boolean)triggerPolicy.notifyTrigger((Object)tuples.get(0)));
                ++i;
            }
        }
    }
}

