/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.policy;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.windowing.policy.CountEvictionPolicy;
import org.junit.Assert;
import org.junit.Test;

public class CountEvictionPolicyTest {
    @Test
    public void testCountEvictionPolicy() {
        List<Integer> tuples = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        boolean triggered = false;
        for (int i = 0; i < 10; ++i) {
            int j;
            CountEvictionPolicy evictionPolicy = new CountEvictionPolicy(i, i);
            int counter = 0;
            for (j = 0; j < i; ++j) {
                String string = "Evictionpolicy with count of " + i + " evicted tuples at add nr. " + ++counter + ". It should not evict for the first " + i + " adds.";
                triggered = !triggered;
                Assert.assertEquals((String)string, (long)0L, (long)evictionPolicy.notifyEviction((Object)tuples.get(j), triggered, tuples.get(Math.abs(i - j) % 10).intValue()));
            }
            for (j = 0; j < 3; ++j) {
                String string = "Evictionpolicy with count of " + i + " did not evict correct number of tuples at the expected pos " + ++counter + ".";
                triggered = !triggered;
                Assert.assertEquals((String)string, (long)i, (long)evictionPolicy.notifyEviction((Object)tuples.get(j), triggered, tuples.get(Math.abs(i - j) % 10).intValue()));
                for (int k = 0; k < i - 1; ++k) {
                    String string2 = "Evictionpolicy with count of " + i + " evicted tuples at add nr. " + ++counter;
                    triggered = !triggered;
                    Assert.assertEquals((String)string2, (long)0L, (long)evictionPolicy.notifyEviction((Object)tuples.get(j), triggered, tuples.get(Math.abs(i - j) % 10).intValue()));
                }
            }
        }
    }

    @Test
    public void testCountEvictionPolicyStartValuesAndEvictionAmount() {
        boolean triggered = false;
        List<Integer> tuples = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        for (int x = 0; x < 4; ++x) {
            for (int i = 0; i < 10; ++i) {
                int counter = 0;
                int j = -5;
                while (i < 6) {
                    CountEvictionPolicy evictionPolicy = new CountEvictionPolicy(i, x, j);
                    for (int k = 0; k < (i - j > 0 ? i - j : 0); ++k) {
                        String string = "Evictionpolicy with count of " + i + " did not evict correct number of tuples at the expected pos " + ++counter + ".";
                        triggered = !triggered;
                        Assert.assertEquals((String)string, (long)0L, (long)evictionPolicy.notifyEviction((Object)tuples.get(Math.abs(j)), triggered, tuples.get(Math.abs(i - j) % 10).intValue()));
                    }
                    String string = "Evictionpolicy with count of " + i + " did not evict correct number of tuples at the expected pos " + ++counter + ".";
                    triggered = !triggered;
                    Assert.assertEquals((String)string, (long)x, (long)evictionPolicy.notifyEviction((Object)tuples.get(Math.abs(j)), triggered, tuples.get(Math.abs(i - j) % 10).intValue()));
                    ++i;
                }
            }
        }
    }
}

