/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.extractor;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.streaming.api.windowing.extractor.FieldsFromTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldsFromTupleTest {
    private double[] testDouble;
    private static final Class<?>[] CLASSES = new Class[]{Tuple1.class, Tuple2.class, Tuple3.class, Tuple4.class, Tuple5.class, Tuple6.class, Tuple7.class, Tuple8.class, Tuple9.class, Tuple10.class, Tuple11.class, Tuple12.class, Tuple13.class, Tuple14.class, Tuple15.class, Tuple16.class, Tuple17.class, Tuple18.class, Tuple19.class, Tuple20.class, Tuple21.class, Tuple22.class, Tuple23.class, Tuple24.class, Tuple25.class};

    @Before
    public void init() {
        this.testDouble = new double[25];
        for (int i = 0; i < 25; ++i) {
            this.testDouble[i] = i;
        }
    }

    @Test
    public void testUserSpecifiedOrder() throws InstantiationException, IllegalAccessException {
        Tuple currentTuple = (Tuple)CLASSES[24].newInstance();
        for (int i = 0; i < 25; ++i) {
            currentTuple.setField((Object)this.testDouble[i], i);
        }
        double[] expected = new double[]{this.testDouble[5], this.testDouble[3], this.testDouble[6], this.testDouble[7], this.testDouble[0]};
        this.arrayEqualityCheck(expected, new FieldsFromTuple(new int[]{5, 3, 6, 7, 0}).extract(currentTuple));
        double[] expected2 = new double[]{this.testDouble[0], this.testDouble[24]};
        this.arrayEqualityCheck(expected2, new FieldsFromTuple(new int[]{0, 24}).extract(currentTuple));
        double[] expected3 = new double[]{this.testDouble[24], this.testDouble[0]};
        this.arrayEqualityCheck(expected3, new FieldsFromTuple(new int[]{24, 0}).extract(currentTuple));
        double[] expected4 = new double[]{this.testDouble[13], this.testDouble[4], this.testDouble[5], this.testDouble[4], this.testDouble[2], this.testDouble[8], this.testDouble[6], this.testDouble[2], this.testDouble[8], this.testDouble[3], this.testDouble[5], this.testDouble[2], this.testDouble[16], this.testDouble[4], this.testDouble[3], this.testDouble[2], this.testDouble[6], this.testDouble[4], this.testDouble[7], this.testDouble[4], this.testDouble[2], this.testDouble[8], this.testDouble[7], this.testDouble[2]};
        this.arrayEqualityCheck(expected4, new FieldsFromTuple(new int[]{13, 4, 5, 4, 2, 8, 6, 2, 8, 3, 5, 2, 16, 4, 3, 2, 6, 4, 7, 4, 2, 8, 7, 2}).extract(currentTuple));
    }

    private void arrayEqualityCheck(double[] array1, double[] array2) {
        Assert.assertEquals((String)"The result arrays must have the same length", (long)array1.length, (long)array2.length);
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((String)("Unequal fields at position " + i), (double)array1[i], (double)array2[i], (double)0.0);
        }
    }
}

