/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.extractor;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.extractor.ArrayFromTuple;
import org.apache.flink.streaming.api.windowing.extractor.ConcatinatedExtract;
import org.apache.flink.streaming.api.windowing.extractor.Extractor;
import org.apache.flink.streaming.api.windowing.extractor.FieldFromArray;
import org.apache.flink.streaming.api.windowing.extractor.FieldFromTuple;
import org.apache.flink.streaming.api.windowing.extractor.FieldsFromArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcatinatedExtractTest {
    private String[] testStringArray1 = new String[]{"1", "2", "3"};
    private int[] testIntArray1 = new int[]{1, 2, 3};
    private String[] testStringArray2 = new String[]{"4", "5", "6"};
    private int[] testIntArray2 = new int[]{4, 5, 6};
    private String[] testStringArray3 = new String[]{"7", "8", "9"};
    private int[] testIntArray3 = new int[]{7, 8, 9};
    private Tuple2<String[], int[]>[] testTuple2Array;
    private Tuple2<String[], int[]> testTuple2;
    private Tuple2<Tuple2<String[], int[]>, Tuple2<String[], int[]>[]> testData;

    @Before
    public void setupData() {
        this.testTuple2Array = new Tuple2[2];
        this.testTuple2Array[0] = new Tuple2((Object)this.testStringArray1, (Object)this.testIntArray2);
        this.testTuple2Array[1] = new Tuple2((Object)this.testStringArray2, (Object)this.testIntArray1);
        this.testTuple2 = new Tuple2((Object)this.testStringArray3, (Object)this.testIntArray3);
        this.testData = new Tuple2(this.testTuple2, this.testTuple2Array);
    }

    @Test
    public void test1() {
        ConcatinatedExtract ext = new ConcatinatedExtract((Extractor)new FieldFromTuple(0), (Extractor)new FieldFromTuple(1)).add((Extractor)new FieldsFromArray(Integer.class, new int[]{2, 1, 0}));
        int[] expected = new int[]{this.testIntArray3[2], this.testIntArray3[1], this.testIntArray3[0]};
        Assert.assertEquals((Object)new Integer(expected[0]), (Object)((Integer[])ext.extract(this.testData))[0]);
        Assert.assertEquals((Object)new Integer(expected[1]), (Object)((Integer[])ext.extract(this.testData))[1]);
        Assert.assertEquals((Object)new Integer(expected[2]), (Object)((Integer[])ext.extract(this.testData))[2]);
    }

    @Test
    public void test2() {
        ConcatinatedExtract ext = new ConcatinatedExtract((Extractor)new FieldFromTuple(1), (Extractor)new FieldsFromArray(Tuple2.class, new int[]{1})).add((Extractor)new FieldFromArray(0)).add((Extractor)new ArrayFromTuple(new int[]{0})).add((Extractor)new FieldFromArray(0)).add((Extractor)new FieldFromArray(1));
        String expected2 = this.testStringArray2[1];
        Assert.assertEquals((Object)expected2, (Object)ext.extract(this.testData));
    }
}

