/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.extractor;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.streaming.api.windowing.extractor.ArrayFromTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayFromTupleTest {
    private String[] testStrings;
    private static final Class<?>[] CLASSES = new Class[]{Tuple1.class, Tuple2.class, Tuple3.class, Tuple4.class, Tuple5.class, Tuple6.class, Tuple7.class, Tuple8.class, Tuple9.class, Tuple10.class, Tuple11.class, Tuple12.class, Tuple13.class, Tuple14.class, Tuple15.class, Tuple16.class, Tuple17.class, Tuple18.class, Tuple19.class, Tuple20.class, Tuple21.class, Tuple22.class, Tuple23.class, Tuple24.class, Tuple25.class};

    @Before
    public void init() {
        this.testStrings = new String[25];
        for (int i = 0; i < 25; ++i) {
            this.testStrings[i] = Integer.toString(i);
        }
    }

    @Test
    public void testConvertFromTupleToArray() throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < 25; ++i) {
            Tuple currentTuple = (Tuple)CLASSES[i].newInstance();
            Object[] currentArray = new String[i + 1];
            for (int j = 0; j <= i; ++j) {
                currentTuple.setField((Object)this.testStrings[j], j);
                currentArray[j] = this.testStrings[j];
            }
            this.arrayEqualityCheck(currentArray, new ArrayFromTuple().extract(currentTuple));
        }
    }

    @Test
    public void testUserSpecifiedOrder() throws InstantiationException, IllegalAccessException {
        Tuple currentTuple = (Tuple)CLASSES[24].newInstance();
        for (int i = 0; i < 25; ++i) {
            currentTuple.setField((Object)this.testStrings[i], i);
        }
        Object[] expected = new String[]{this.testStrings[5], this.testStrings[3], this.testStrings[6], this.testStrings[7], this.testStrings[0]};
        this.arrayEqualityCheck(expected, new ArrayFromTuple(new int[]{5, 3, 6, 7, 0}).extract(currentTuple));
        Object[] expected2 = new String[]{this.testStrings[0], this.testStrings[24]};
        this.arrayEqualityCheck(expected2, new ArrayFromTuple(new int[]{0, 24}).extract(currentTuple));
        Object[] expected3 = new String[]{this.testStrings[24], this.testStrings[0]};
        this.arrayEqualityCheck(expected3, new ArrayFromTuple(new int[]{24, 0}).extract(currentTuple));
        Object[] expected4 = new String[]{this.testStrings[13], this.testStrings[4], this.testStrings[5], this.testStrings[4], this.testStrings[2], this.testStrings[8], this.testStrings[6], this.testStrings[2], this.testStrings[8], this.testStrings[3], this.testStrings[5], this.testStrings[2], this.testStrings[16], this.testStrings[4], this.testStrings[3], this.testStrings[2], this.testStrings[6], this.testStrings[4], this.testStrings[7], this.testStrings[4], this.testStrings[2], this.testStrings[8], this.testStrings[7], this.testStrings[2]};
        this.arrayEqualityCheck(expected4, new ArrayFromTuple(new int[]{13, 4, 5, 4, 2, 8, 6, 2, 8, 3, 5, 2, 16, 4, 3, 2, 6, 4, 7, 4, 2, 8, 7, 2}).extract(currentTuple));
    }

    private void arrayEqualityCheck(Object[] array1, Object[] array2) {
        Assert.assertEquals((String)"The result arrays must have the same length", (long)array1.length, (long)array2.length);
        for (int i = 0; i < array1.length; ++i) {
            Assert.assertEquals((String)("Unequal fields at position " + i), (Object)array1[i], (Object)array2[i]);
        }
    }
}

