/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.invokable.operator.MapInvokable;
import org.apache.flink.streaming.util.MockContext;
import org.junit.Assert;
import org.junit.Test;

public class MapTest {
    @Test
    public void mapInvokableTest() {
        MapInvokable invokable = new MapInvokable((MapFunction)new Map());
        List<String> expectedList = Arrays.asList("+2", "+3", "+4");
        List actualList = MockContext.createAndExecute(invokable, Arrays.asList(1, 2, 3));
        Assert.assertEquals(expectedList, actualList);
    }

    private static class Map
    implements MapFunction<Integer, String> {
        private static final long serialVersionUID = 1L;

        private Map() {
        }

        public String map(Integer value) throws Exception {
            return "+" + (value + 1);
        }
    }
}

