/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.streaming.api.invokable.operator.FlatMapInvokable;
import org.apache.flink.streaming.util.MockContext;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class FlatMapTest {
    @Test
    public void flatMapTest() {
        FlatMapInvokable invokable = new FlatMapInvokable((FlatMapFunction)new MyFlatMap());
        List<Integer> expected = Arrays.asList(2, 4, 4, 16, 6, 36, 8, 64);
        List actual = MockContext.createAndExecute(invokable, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8));
        Assert.assertEquals(expected, actual);
    }

    public static final class MyFlatMap
    implements FlatMapFunction<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Integer value, Collector<Integer> out) throws Exception {
            if (value % 2 == 0) {
                out.collect((Object)value);
                out.collect((Object)(value * value));
            }
        }
    }
}

