/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.function.co.CoWindowFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoWindowInvokable;
import org.apache.flink.streaming.api.windowing.helper.Timestamp;
import org.apache.flink.streaming.api.windowing.helper.TimestampWrapper;
import org.apache.flink.streaming.util.MockCoContext;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoWindowTest {
    @Test
    public void coWindowGroupReduceTest2() throws Exception {
        CoWindowInvokable invokable1 = new CoWindowInvokable((CoWindowFunction)new MyCoGroup1(), 2L, 1L, new TimestampWrapper((Timestamp)new MyTS1(), 1L), new TimestampWrapper((Timestamp)new MyTS1(), 1L));
        ArrayList<Integer> input11 = new ArrayList<Integer>();
        input11.add(1);
        input11.add(1);
        input11.add(2);
        input11.add(3);
        input11.add(3);
        ArrayList<Integer> input12 = new ArrayList<Integer>();
        input12.add(1);
        input12.add(2);
        input12.add(3);
        input12.add(3);
        input12.add(5);
        ArrayList<Integer> expected1 = new ArrayList<Integer>();
        expected1.add(3);
        expected1.add(2);
        expected1.add(3);
        expected1.add(3);
        expected1.add(2);
        expected1.add(2);
        expected1.add(0);
        expected1.add(1);
        List actual1 = MockCoContext.createAndExecute(invokable1, input11, input12);
        Assert.assertEquals(expected1, actual1);
        CoWindowInvokable invokable2 = new CoWindowInvokable((CoWindowFunction)new MyCoGroup2(), 2L, 3L, new TimestampWrapper((Timestamp)new MyTS2(), 1L), new TimestampWrapper((Timestamp)new MyTS2(), 1L));
        ArrayList<Tuple2> input21 = new ArrayList<Tuple2>();
        input21.add(new Tuple2((Object)1, (Object)1));
        input21.add(new Tuple2((Object)1, (Object)2));
        input21.add(new Tuple2((Object)2, (Object)3));
        input21.add(new Tuple2((Object)3, (Object)4));
        input21.add(new Tuple2((Object)3, (Object)5));
        input21.add(new Tuple2((Object)4, (Object)6));
        input21.add(new Tuple2((Object)4, (Object)7));
        input21.add(new Tuple2((Object)5, (Object)8));
        ArrayList<Tuple2> input22 = new ArrayList<Tuple2>();
        input22.add(new Tuple2((Object)1, (Object)1));
        input22.add(new Tuple2((Object)2, (Object)0));
        input22.add(new Tuple2((Object)2, (Object)2));
        input22.add(new Tuple2((Object)3, (Object)9));
        input22.add(new Tuple2((Object)3, (Object)4));
        input22.add(new Tuple2((Object)4, (Object)10));
        input22.add(new Tuple2((Object)5, (Object)8));
        input22.add(new Tuple2((Object)5, (Object)7));
        ArrayList<Integer> expected2 = new ArrayList<Integer>();
        expected2.add(1);
        expected2.add(2);
        expected2.add(8);
        expected2.add(7);
        List actual2 = MockCoContext.createAndExecute(invokable2, input21, input22);
        Assert.assertEquals(expected2, actual2);
    }

    private static final class MyTS2
    implements Timestamp<Tuple2<Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        private MyTS2() {
        }

        public long getTimestamp(Tuple2<Integer, Integer> value) {
            return ((Integer)value.f0).intValue();
        }
    }

    private static final class MyTS1
    implements Timestamp<Integer> {
        private static final long serialVersionUID = 1L;

        private MyTS1() {
        }

        public long getTimestamp(Integer value) {
            return value.intValue();
        }
    }

    public static final class MyCoGroup2
    implements CoWindowFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Integer> {
        private static final long serialVersionUID = 1L;

        public void coWindow(List<Tuple2<Integer, Integer>> first, List<Tuple2<Integer, Integer>> second, Collector<Integer> out) throws Exception {
            HashSet<Object> firstElements = new HashSet<Object>();
            for (Tuple2<Integer, Integer> value : first) {
                firstElements.add(value.f1);
            }
            for (Tuple2<Integer, Integer> value : second) {
                if (!firstElements.contains(value.f1)) continue;
                out.collect(value.f1);
            }
        }
    }

    public static final class MyCoGroup1
    implements CoWindowFunction<Integer, Integer, Integer> {
        private static final long serialVersionUID = 1L;

        public void coWindow(List<Integer> first, List<Integer> second, Collector<Integer> out) throws Exception {
            Integer n;
            Integer count1 = 0;
            for (Integer i : first) {
                Integer n2 = count1;
                n = count1 = Integer.valueOf(count1 + 1);
            }
            Integer count2 = 0;
            for (Integer i : second) {
                n = count2;
                Integer n3 = count2 = Integer.valueOf(count2 + 1);
            }
            out.collect((Object)count1);
            out.collect((Object)count2);
        }
    }
}

