/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.function.co.CoReduceFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoReduceInvokable;
import org.apache.flink.streaming.util.MockCoContext;
import org.junit.Assert;
import org.junit.Test;

public class CoStreamReduceTest {
    @Test
    public void coStreamReduceTest() {
        CoReduceInvokable coReduce = new CoReduceInvokable((CoReduceFunction)new MyCoReduceFunction());
        List<Integer> expected1 = Arrays.asList(1, 9, 2, 99, 6, 998, 24);
        List result = MockCoContext.createAndExecute(coReduce, Arrays.asList(1, 2, 3, 4), Arrays.asList("9", "9", "8"));
        Assert.assertEquals(expected1, result);
    }

    public static class MyCoReduceFunction
    implements CoReduceFunction<Integer, String, Integer> {
        private static final long serialVersionUID = 1L;

        public Integer reduce1(Integer value1, Integer value2) {
            return value1 * value2;
        }

        public String reduce2(String value1, String value2) {
            return value1 + value2;
        }

        public Integer map1(Integer value) {
            return value;
        }

        public Integer map2(String value) {
            return Integer.parseInt(value);
        }
    }
}

