/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.function.co.CoMapFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoMapInvokable;
import org.apache.flink.streaming.util.MockCoContext;
import org.junit.Assert;
import org.junit.Test;

public class CoMapTest
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Test
    public void coMapTest() {
        CoMapInvokable invokable = new CoMapInvokable((CoMapFunction)new MyCoMap());
        List<String> expectedList = Arrays.asList("1.1", "1", "1.2", "2", "1.3", "3", "1.4", "1.5");
        List actualList = MockCoContext.createAndExecute(invokable, Arrays.asList(1.1, 1.2, 1.3, 1.4, 1.5), Arrays.asList(1, 2, 3));
        Assert.assertEquals(expectedList, actualList);
    }

    private static final class MyCoMap
    implements CoMapFunction<Double, Integer, String> {
        private static final long serialVersionUID = 1L;

        private MyCoMap() {
        }

        public String map1(Double value) {
            return value.toString();
        }

        public String map2(Integer value) {
            return value.toString();
        }
    }
}

