/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.api.function.co.CoReduceFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoGroupedReduceInvokable;
import org.apache.flink.streaming.util.MockCoContext;
import org.junit.Assert;
import org.junit.Test;

public class CoGroupedReduceTest {
    @Test
    public void coGroupedReduceTest() {
        Tuple3 word1 = new Tuple3((Object)"a", (Object)"word1", (Object)"b");
        Tuple3 word2 = new Tuple3((Object)"b", (Object)"word2", (Object)"a");
        Tuple3 word3 = new Tuple3((Object)"a", (Object)"word3", (Object)"a");
        Tuple2 int1 = new Tuple2((Object)2, (Object)1);
        Tuple2 int2 = new Tuple2((Object)1, (Object)2);
        Tuple2 int3 = new Tuple2((Object)0, (Object)3);
        Tuple2 int4 = new Tuple2((Object)2, (Object)4);
        Tuple2 int5 = new Tuple2((Object)1, (Object)5);
        KeySelector<Tuple3<String, String, String>, String> keySelector0 = new KeySelector<Tuple3<String, String, String>, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple3<String, String, String> value) throws Exception {
                return (String)value.f0;
            }
        };
        KeySelector<Tuple2<Integer, Integer>, Integer> keySelector1 = new KeySelector<Tuple2<Integer, Integer>, Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getKey(Tuple2<Integer, Integer> value) throws Exception {
                return (Integer)value.f0;
            }
        };
        KeySelector<Tuple3<String, String, String>, String> keySelector2 = new KeySelector<Tuple3<String, String, String>, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple3<String, String, String> value) throws Exception {
                return (String)value.f2;
            }
        };
        CoGroupedReduceInvokable invokable = new CoGroupedReduceInvokable((CoReduceFunction)new MyCoReduceFunction(), (KeySelector)keySelector0, (KeySelector)keySelector1);
        List<String> expected = Arrays.asList("word1", "1", "word2", "2", "word1word3", "3", "5", "7");
        List actualList = MockCoContext.createAndExecute(invokable, Arrays.asList(word1, word2, word3), Arrays.asList(int1, int2, int3, int4, int5));
        Assert.assertEquals(expected, actualList);
        invokable = new CoGroupedReduceInvokable((CoReduceFunction)new MyCoReduceFunction(), (KeySelector)keySelector2, (KeySelector)keySelector1);
        expected = Arrays.asList("word1", "1", "word2", "2", "word2word3", "3", "5", "7");
        actualList = MockCoContext.createAndExecute(invokable, Arrays.asList(word1, word2, word3), Arrays.asList(int1, int2, int3, int4, int5));
        Assert.assertEquals(expected, actualList);
    }

    private static final class MyCoReduceFunction
    implements CoReduceFunction<Tuple3<String, String, String>, Tuple2<Integer, Integer>, String> {
        private static final long serialVersionUID = 1L;

        private MyCoReduceFunction() {
        }

        public Tuple3<String, String, String> reduce1(Tuple3<String, String, String> value1, Tuple3<String, String, String> value2) {
            return new Tuple3(value1.f0, (Object)((String)value1.f1 + (String)value2.f1), value1.f2);
        }

        public Tuple2<Integer, Integer> reduce2(Tuple2<Integer, Integer> value1, Tuple2<Integer, Integer> value2) {
            return new Tuple2(value1.f0, (Object)((Integer)value1.f1 + (Integer)value2.f1));
        }

        public String map1(Tuple3<String, String, String> value) {
            return (String)value.f1;
        }

        public String map2(Tuple2<Integer, Integer> value) {
            return ((Integer)value.f1).toString();
        }
    }
}

