/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.invokable.operator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.invokable.operator.co.CoFlatMapInvokable;
import org.apache.flink.streaming.util.MockCoContext;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoFlatMapTest
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Test
    public void coFlatMapTest() {
        CoFlatMapInvokable invokable = new CoFlatMapInvokable((CoFlatMapFunction)new MyCoFlatMap());
        List<String> expectedList = Arrays.asList("a", "b", "c", "1", "d", "e", "f", "2", "g", "h", "e", "3", "4", "5");
        List actualList = MockCoContext.createAndExecute(invokable, Arrays.asList("abc", "def", "ghe"), Arrays.asList(1, 2, 3, 4, 5));
        Assert.assertEquals(expectedList, actualList);
    }

    @Test
    public void multipleInputTest() {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        DataStreamSource ds1 = env.fromElements((Serializable[])new Integer[]{1, 3, 5});
        DataStream ds2 = env.fromElements((Serializable[])new Integer[]{2, 4}).merge(new DataStream[]{ds1});
        try {
            ds1.forward().merge(new DataStream[]{ds2});
            Assert.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    private static final class MyCoFlatMap
    implements CoFlatMapFunction<String, Integer, String> {
        private static final long serialVersionUID = 1L;

        private MyCoFlatMap() {
        }

        public void flatMap1(String value, Collector<String> coll) {
            for (int i = 0; i < value.length(); ++i) {
                coll.collect((Object)value.substring(i, i + 1));
            }
        }

        public void flatMap2(Integer value, Collector<String> coll) {
            coll.collect((Object)value.toString());
        }
    }
}

