/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.function.source.FromElementsFunction;
import org.apache.flink.streaming.api.function.source.SocketTextStreamFunction;
import org.apache.flink.streaming.util.MockCollector;
import org.apache.flink.streaming.util.MockSource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SourceTest {
    @Test
    public void fromElementsTest() {
        List<Integer> expectedList = Arrays.asList(1, 2, 3);
        List actualList = MockSource.createAndExecute(new FromElementsFunction((Object[])new Integer[]{1, 2, 3}));
        Assert.assertEquals(expectedList, actualList);
    }

    @Test
    public void fromCollectionTest() {
        List<Integer> expectedList = Arrays.asList(1, 2, 3);
        List actualList = MockSource.createAndExecute(new FromElementsFunction(Arrays.asList(1, 2, 3)));
        Assert.assertEquals(expectedList, actualList);
    }

    @Test
    public void socketTextStreamTest() throws Exception {
        List<String> expectedList = Arrays.asList("a", "b", "c");
        ArrayList actualList = new ArrayList();
        byte[] data = new byte[]{97, 10, 98, 10, 99, 10};
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getInputStream()).thenReturn((Object)new ByteArrayInputStream(data));
        Mockito.when((Object)socket.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)socket.isConnected()).thenReturn((Object)true);
        new SocketTextStreamFunction("", 0, '\n').streamFromSocket(new MockCollector(actualList), socket);
        Assert.assertEquals(expectedList, actualList);
    }
}

