/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.IterativeDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.sink.SinkFunction;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class IterateTest {
    private static final long MEMORYSIZE = 32L;
    private static boolean iterated = false;

    @Test
    public void test() throws Exception {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        env.setBufferTimeout(10L);
        DataStreamSource source = env.fromElements((Serializable[])new Boolean[]{false, false, false});
        IterativeDataStream iteration = source.iterate(3000L);
        SingleOutputStreamOperator increment = iteration.flatMap((FlatMapFunction)new IterationHead()).flatMap((FlatMapFunction)new IterationTail());
        iteration.closeWith((DataStream)increment).addSink((SinkFunction)new MySink());
        env.executeTest(32L);
        Assert.assertTrue((boolean)iterated);
    }

    public static final class MySink
    implements SinkFunction<Boolean> {
        private static final long serialVersionUID = 1L;

        public void invoke(Boolean tuple) {
        }
    }

    public static final class IterationTail
    extends RichFlatMapFunction<Boolean, Boolean> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Boolean value, Collector<Boolean> out) throws Exception {
            out.collect((Object)true);
        }
    }

    public static final class IterationHead
    extends RichFlatMapFunction<Boolean, Boolean> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Boolean value, Collector<Boolean> out) throws Exception {
            if (value.booleanValue()) {
                iterated = true;
            } else {
                out.collect((Object)value);
            }
        }
    }
}

