/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.function.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.function.aggregation.SumAggregator;
import org.apache.flink.streaming.api.invokable.operator.GroupedReduceInvokable;
import org.apache.flink.streaming.api.invokable.operator.StreamReduceInvokable;
import org.apache.flink.streaming.util.MockContext;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;
import org.junit.Assert;
import org.junit.Test;

public class AggregationFunctionTest {
    @Test
    public void groupSumIntegerTest() {
        ArrayList<Tuple2> expectedSumList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedMinList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedMaxList = new ArrayList<Tuple2>();
        ArrayList<Integer> expectedSumList0 = new ArrayList<Integer>();
        ArrayList<Integer> expectedMinList0 = new ArrayList<Integer>();
        ArrayList<Integer> expectedMaxList0 = new ArrayList<Integer>();
        ArrayList<Tuple2> expectedGroupSumList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedGroupMinList = new ArrayList<Tuple2>();
        ArrayList<Tuple2> expectedGroupMaxList = new ArrayList<Tuple2>();
        ArrayList<Integer> simpleInput = new ArrayList<Integer>();
        int groupedSum0 = 0;
        int groupedSum1 = 0;
        int groupedSum2 = 0;
        for (int i = 0; i < 9; ++i) {
            int groupedSum;
            simpleInput.add(i);
            expectedSumList.add(new Tuple2((Object)(i % 3), (Object)((i + 1) * i / 2)));
            expectedMinList.add(new Tuple2((Object)(i % 3), (Object)0));
            expectedMaxList.add(new Tuple2((Object)(i % 3), (Object)i));
            expectedSumList0.add((i + 1) * i / 2);
            expectedMaxList0.add(i);
            expectedMinList0.add(0);
            switch (i % 3) {
                case 0: {
                    groupedSum = groupedSum0 += i;
                    break;
                }
                case 1: {
                    groupedSum = groupedSum1 += i;
                    break;
                }
                default: {
                    groupedSum = groupedSum2 += i;
                }
            }
            expectedGroupSumList.add(new Tuple2((Object)(i % 3), (Object)groupedSum));
            expectedGroupMinList.add(new Tuple2((Object)(i % 3), (Object)(i % 3)));
            expectedGroupMaxList.add(new Tuple2((Object)(i % 3), (Object)i));
        }
        TypeInformation type1 = TypeExtractor.getForObject((Object)new Tuple2((Object)0, (Object)0));
        TypeInformation type2 = TypeExtractor.getForObject((Object)2);
        ReduceFunction sumFunction = SumAggregator.getSumFunction((int)1, Integer.class, (TypeInformation)type1);
        ReduceFunction sumFunction0 = SumAggregator.getSumFunction((int)0, Integer.class, (TypeInformation)type2);
        AggregationFunction minFunction = ComparableAggregator.getAggregator((int)1, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MIN);
        AggregationFunction minFunction0 = ComparableAggregator.getAggregator((int)0, (TypeInformation)type2, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MIN);
        AggregationFunction maxFunction = ComparableAggregator.getAggregator((int)1, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAX);
        AggregationFunction maxFunction0 = ComparableAggregator.getAggregator((int)0, (TypeInformation)type2, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAX);
        List sumList = MockContext.createAndExecute(new StreamReduceInvokable(sumFunction), this.getInputList());
        List minList = MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minFunction), this.getInputList());
        List maxList = MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxFunction), this.getInputList());
        TypeInformation typeInfo = TypeExtractor.getForObject((Object)new Tuple2((Object)1, (Object)1));
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys((Keys)new Keys.ExpressionKeys(new int[]{0}, typeInfo), (TypeInformation)typeInfo);
        List groupedSumList = MockContext.createAndExecute(new GroupedReduceInvokable(sumFunction, keySelector), this.getInputList());
        List groupedMinList = MockContext.createAndExecute(new GroupedReduceInvokable((ReduceFunction)minFunction, keySelector), this.getInputList());
        List groupedMaxList = MockContext.createAndExecute(new GroupedReduceInvokable((ReduceFunction)maxFunction, keySelector), this.getInputList());
        Assert.assertEquals(expectedSumList, sumList);
        Assert.assertEquals(expectedMinList, minList);
        Assert.assertEquals(expectedMaxList, maxList);
        Assert.assertEquals(expectedGroupSumList, groupedSumList);
        Assert.assertEquals(expectedGroupMinList, groupedMinList);
        Assert.assertEquals(expectedGroupMaxList, groupedMaxList);
        Assert.assertEquals(expectedSumList0, MockContext.createAndExecute(new StreamReduceInvokable(sumFunction0), simpleInput));
        Assert.assertEquals(expectedMinList0, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minFunction0), simpleInput));
        Assert.assertEquals(expectedMaxList0, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxFunction0), simpleInput));
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment();
        try {
            env.generateSequence(1L, 100L).min(1);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            env.generateSequence(1L, 100L).min(2);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            env.generateSequence(1L, 100L).min(3);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        AggregationFunction maxByFunctionFirst = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAXBY, (boolean)true);
        AggregationFunction maxByFunctionLast = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAXBY, (boolean)false);
        AggregationFunction minByFunctionFirst = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MINBY, (boolean)true);
        AggregationFunction minByFunctionLast = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MINBY, (boolean)false);
        ArrayList<Tuple2> maxByFirstExpected = new ArrayList<Tuple2>();
        maxByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        maxByFirstExpected.add(new Tuple2((Object)1, (Object)1));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        ArrayList<Tuple2> maxByLastExpected = new ArrayList<Tuple2>();
        maxByLastExpected.add(new Tuple2((Object)0, (Object)0));
        maxByLastExpected.add(new Tuple2((Object)1, (Object)1));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)8));
        ArrayList<Tuple2> minByFirstExpected = new ArrayList<Tuple2>();
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        ArrayList<Tuple2> minByLastExpected = new ArrayList<Tuple2>();
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        Assert.assertEquals(maxByFirstExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxByFunctionFirst), this.getInputList()));
        Assert.assertEquals(maxByLastExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxByFunctionLast), this.getInputList()));
        Assert.assertEquals(minByLastExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minByFunctionLast), this.getInputList()));
        Assert.assertEquals(minByFirstExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minByFunctionFirst), this.getInputList()));
    }

    @Test
    public void minMaxByTest() {
        TypeInformation type1 = TypeExtractor.getForObject((Object)new Tuple2((Object)0, (Object)0));
        AggregationFunction maxByFunctionFirst = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAXBY, (boolean)true);
        AggregationFunction maxByFunctionLast = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MAXBY, (boolean)false);
        AggregationFunction minByFunctionFirst = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MINBY, (boolean)true);
        AggregationFunction minByFunctionLast = ComparableAggregator.getAggregator((int)0, (TypeInformation)type1, (AggregationFunction.AggregationType)AggregationFunction.AggregationType.MINBY, (boolean)false);
        ArrayList<Tuple2> maxByFirstExpected = new ArrayList<Tuple2>();
        maxByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        maxByFirstExpected.add(new Tuple2((Object)1, (Object)1));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        maxByFirstExpected.add(new Tuple2((Object)2, (Object)2));
        ArrayList<Tuple2> maxByLastExpected = new ArrayList<Tuple2>();
        maxByLastExpected.add(new Tuple2((Object)0, (Object)0));
        maxByLastExpected.add(new Tuple2((Object)1, (Object)1));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)2));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)5));
        maxByLastExpected.add(new Tuple2((Object)2, (Object)8));
        ArrayList<Tuple2> minByFirstExpected = new ArrayList<Tuple2>();
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        minByFirstExpected.add(new Tuple2((Object)0, (Object)0));
        ArrayList<Tuple2> minByLastExpected = new ArrayList<Tuple2>();
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)0));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)3));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        minByLastExpected.add(new Tuple2((Object)0, (Object)6));
        Assert.assertEquals(maxByFirstExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxByFunctionFirst), this.getInputList()));
        Assert.assertEquals(maxByLastExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)maxByFunctionLast), this.getInputList()));
        Assert.assertEquals(minByLastExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minByFunctionLast), this.getInputList()));
        Assert.assertEquals(minByFirstExpected, MockContext.createAndExecute(new StreamReduceInvokable((ReduceFunction)minByFunctionFirst), this.getInputList()));
    }

    private List<Tuple2<Integer, Integer>> getInputList() {
        ArrayList<Tuple2<Integer, Integer>> inputList = new ArrayList<Tuple2<Integer, Integer>>();
        for (int i = 0; i < 9; ++i) {
            inputList.add((Tuple2<Integer, Integer>)new Tuple2((Object)(i % 3), (Object)i));
        }
        return inputList;
    }
}

