/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift7;

import org.apache.thrift7.TApplicationException;
import org.apache.thrift7.TBase;
import org.apache.thrift7.TException;
import org.apache.thrift7.protocol.TMessage;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.protocol.TProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessFunction<I, T extends TBase> {
    private final String methodName;

    public ProcessFunction(String methodName) {
        this.methodName = methodName;
    }

    public final void process(int seqid, TProtocol iprot, TProtocol oprot, I iface) throws TException {
        T args = this.getEmptyArgsInstance();
        try {
            args.read(iprot);
        }
        catch (TProtocolException e) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        TBase result2 = this.getResult(iface, args);
        oprot.writeMessageBegin(new TMessage(this.getMethodName(), 2, seqid));
        result2.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
    }

    protected abstract TBase getResult(I var1, T var2) throws TException;

    protected abstract T getEmptyArgsInstance();

    public String getMethodName() {
        return this.methodName;
    }
}

