/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.wrappers;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.SpoutSpec;
import backtype.storm.generated.StateSpoutSpec;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.StreamInfo;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IComponent;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.tuple.Fields;
import clojure.lang.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.storm.wrappers.FlinkTopologyContext;
import org.apache.flink.storm.wrappers.SetupOutputFieldsDeclarer;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;

class WrapperSetupHelper {
    static final String TOPOLOGY_NAME = "storm.topology.name";
    private static int tid;

    WrapperSetupHelper() {
    }

    static HashMap<String, Integer> getNumberOfAttributes(IComponent spoutOrBolt, Collection<String> rawOutputs) throws IllegalArgumentException {
        SetupOutputFieldsDeclarer declarer = new SetupOutputFieldsDeclarer();
        spoutOrBolt.declareOutputFields(declarer);
        for (Map.Entry<String, Integer> schema : declarer.outputSchemas.entrySet()) {
            int declaredNumberOfAttributes = schema.getValue();
            if (declaredNumberOfAttributes < 0 || declaredNumberOfAttributes > 25) {
                throw new IllegalArgumentException("Provided bolt declares non supported number of output attributes. Must be in range [0;25] but was " + declaredNumberOfAttributes);
            }
            if (rawOutputs == null || !rawOutputs.contains(schema.getKey())) continue;
            if (declaredNumberOfAttributes != 1) {
                throw new IllegalArgumentException("Ouput type is requested to be raw type, but provided bolt declares more then one output attribute.");
            }
            schema.setValue(-1);
        }
        return declarer.outputSchemas;
    }

    /*
     * WARNING - void declaration
     */
    static synchronized TopologyContext createTopologyContext(StreamingRuntimeContext context, IComponent spoutOrBolt, String operatorName, StormTopology stormTopology, Map stormConfig) {
        int dop = context.getNumberOfParallelSubtasks();
        HashMap<Integer, String> taskToComponents = new HashMap<Integer, String>();
        HashMap<String, List<Integer>> componentToSortedTasks = new HashMap<String, List<Integer>>();
        HashMap<String, Map<String, Fields>> componentToStreamToFields = new HashMap<String, Map<String, Fields>>();
        String stormId = (String)stormConfig.get(TOPOLOGY_NAME);
        String codeDir = null;
        String pidDir = null;
        Integer taskId = -1;
        Integer workerPort = null;
        ArrayList<Integer> workerTasks = new ArrayList<Integer>();
        HashMap<String, Object> defaultResources = new HashMap<String, Object>();
        HashMap<String, Object> userResources = new HashMap<String, Object>();
        HashMap<String, Object> executorData = new HashMap<String, Object>();
        HashMap registeredMetrics = new HashMap();
        Atom openOrPrepareWasCalled = null;
        if (stormTopology == null) {
            void var24_29;
            ComponentCommon common = new ComponentCommon();
            common.set_parallelism_hint(dop);
            HashMap<String, SpoutSpec> spouts = new HashMap<String, SpoutSpec>();
            HashMap<String, Bolt> bolts = new HashMap<String, Bolt>();
            if (spoutOrBolt instanceof IRichSpout) {
                spouts.put(operatorName, new SpoutSpec(null, common));
            } else {
                assert (spoutOrBolt instanceof IRichBolt);
                bolts.put(operatorName, new Bolt(null, common));
            }
            stormTopology = new StormTopology(spouts, bolts, new HashMap<String, StateSpoutSpec>());
            ArrayList<Integer> sortedTasks = new ArrayList<Integer>(dop);
            boolean bl = true;
            while (var24_29 <= dop) {
                taskToComponents.put((int)var24_29, operatorName);
                sortedTasks.add((int)var24_29);
                ++var24_29;
            }
            componentToSortedTasks.put(operatorName, sortedTasks);
            SetupOutputFieldsDeclarer setupOutputFieldsDeclarer = new SetupOutputFieldsDeclarer();
            spoutOrBolt.declareOutputFields(setupOutputFieldsDeclarer);
            componentToStreamToFields.put(operatorName, setupOutputFieldsDeclarer.outputStreams);
        } else {
            Integer rc;
            Map<String, SpoutSpec> spouts = stormTopology.get_spouts();
            Map<String, Bolt> bolts = stormTopology.get_bolts();
            Map<String, StateSpoutSpec> stateSpouts = stormTopology.get_state_spouts();
            tid = 1;
            for (Map.Entry<String, SpoutSpec> entry : spouts.entrySet()) {
                rc = WrapperSetupHelper.processSingleOperator(entry.getKey(), entry.getValue().get_common(), operatorName, context.getIndexOfThisSubtask(), dop, taskToComponents, componentToSortedTasks, componentToStreamToFields);
                if (rc == null) continue;
                taskId = rc;
            }
            for (Map.Entry<String, Cloneable> entry : bolts.entrySet()) {
                rc = WrapperSetupHelper.processSingleOperator(entry.getKey(), ((Bolt)entry.getValue()).get_common(), operatorName, context.getIndexOfThisSubtask(), dop, taskToComponents, componentToSortedTasks, componentToStreamToFields);
                if (rc == null) continue;
                taskId = rc;
            }
            for (Map.Entry<String, Cloneable> entry : stateSpouts.entrySet()) {
                rc = WrapperSetupHelper.processSingleOperator(entry.getKey(), ((StateSpoutSpec)entry.getValue()).get_common(), operatorName, context.getIndexOfThisSubtask(), dop, taskToComponents, componentToSortedTasks, componentToStreamToFields);
                if (rc == null) continue;
                taskId = rc;
            }
            assert (taskId != null);
        }
        if (!stormConfig.containsKey("topology.message.timeout.secs")) {
            stormConfig.put("topology.message.timeout.secs", 30);
        }
        return new FlinkTopologyContext(stormTopology, stormConfig, taskToComponents, componentToSortedTasks, componentToStreamToFields, stormId, codeDir, pidDir, taskId, workerPort, workerTasks, defaultResources, userResources, executorData, registeredMetrics, openOrPrepareWasCalled);
    }

    private static Integer processSingleOperator(String componentId, ComponentCommon common, String operatorName, int index, int dop, Map<Integer, String> taskToComponents, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields) {
        int parallelism_hint = common.get_parallelism_hint();
        Integer taskId = null;
        if (componentId.equals(operatorName)) {
            taskId = tid + index;
        }
        ArrayList<Integer> sortedTasks = new ArrayList<Integer>(dop);
        for (int i = 0; i < parallelism_hint; ++i) {
            taskToComponents.put(tid, componentId);
            sortedTasks.add(tid);
            ++tid;
        }
        componentToSortedTasks.put(componentId, sortedTasks);
        HashMap<String, Fields> outputStreams = new HashMap<String, Fields>();
        for (Map.Entry<String, StreamInfo> outStream : common.get_streams().entrySet()) {
            outputStreams.put(outStream.getKey(), new Fields(outStream.getValue().get_output_fields()));
        }
        componentToStreamToFields.put(componentId, outputStreams);
        return taskId;
    }
}

