/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.wrappers;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.MessageId;
import backtype.storm.tuple.Values;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple;

public class StormTuple<IN>
implements backtype.storm.tuple.Tuple {
    private final Values stormTuple;
    private final Fields schema;
    private final int producerTaskId;
    private final String producerStreamId;
    private final String producerComponentId;
    private final MessageId messageId;

    public StormTuple(IN flinkTuple, Fields schema, int producerTaskId, String producerStreamId, String producerComponentId, MessageId messageId) {
        if (flinkTuple instanceof Tuple) {
            Tuple t = (Tuple)flinkTuple;
            int numberOfAttributes = producerTaskId < 0 ? t.getArity() : t.getArity() - 1;
            this.stormTuple = new Values();
            for (int i = 0; i < numberOfAttributes; ++i) {
                this.stormTuple.add(t.getField(i));
            }
        } else {
            this.stormTuple = new Values(flinkTuple);
        }
        this.schema = schema;
        this.producerTaskId = producerTaskId;
        this.producerStreamId = producerStreamId;
        this.producerComponentId = producerComponentId;
        this.messageId = messageId;
    }

    @Override
    public int size() {
        return this.stormTuple.size();
    }

    @Override
    public boolean contains(String field) {
        if (this.schema != null) {
            return this.schema.contains(field);
        }
        try {
            this.getPublicMemberField(field);
            return true;
        }
        catch (NoSuchFieldException f) {
            try {
                this.getGetterMethod(field);
                return true;
            }
            catch (Exception g) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Fields getFields() {
        return this.schema;
    }

    @Override
    public int fieldIndex(String field) {
        return this.schema.fieldIndex(field);
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.schema.select(selector, this.stormTuple);
    }

    @Override
    public Object getValue(int i) {
        return this.stormTuple.get(i);
    }

    @Override
    public String getString(int i) {
        return (String)this.stormTuple.get(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.stormTuple.get(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.stormTuple.get(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.stormTuple.get(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.stormTuple.get(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.stormTuple.get(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.stormTuple.get(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.stormTuple.get(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.stormTuple.get(i);
    }

    private Field getPublicMemberField(String field) throws Exception {
        assert (this.stormTuple.size() == 1);
        return this.stormTuple.get(0).getClass().getField(field);
    }

    private Method getGetterMethod(String field) throws Exception {
        assert (this.stormTuple.size() == 1);
        return this.stormTuple.get(0).getClass().getMethod("get" + Character.toUpperCase(field.charAt(0)) + field.substring(1), null);
    }

    private Object getValueByPublicMember(String field) throws Exception {
        assert (this.stormTuple.size() == 1);
        return this.getPublicMemberField(field).get(this.stormTuple.get(0));
    }

    private Object getValueByGetter(String field) throws Exception {
        assert (this.stormTuple.size() == 1);
        return this.getGetterMethod(field).invoke(this.stormTuple.get(0), (Object[])null);
    }

    public <T> T getValueByName(String field) {
        Exception e;
        if (this.schema != null) {
            return (T)this.getValue(this.schema.fieldIndex(field));
        }
        assert (this.stormTuple.size() == 1);
        try {
            return (T)this.getValueByPublicMember(field);
        }
        catch (NoSuchFieldException f) {
            try {
                return (T)this.getValueByGetter(field);
            }
            catch (Exception g) {
                e = g;
            }
        }
        catch (Exception f) {
            e = f;
        }
        throw new RuntimeException("Could not access field <" + field + ">", e);
    }

    @Override
    public Object getValueByField(String field) {
        return this.getValueByName(field);
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.getValueByName(field);
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.getValueByName(field);
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.getValueByName(field);
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.getValueByName(field);
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.getValueByName(field);
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.getValueByName(field);
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.getValueByName(field);
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.getValueByName(field);
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.getValueByName(field);
    }

    @Override
    public List<Object> getValues() {
        return this.stormTuple;
    }

    @Override
    public GlobalStreamId getSourceGlobalStreamid() {
        return new GlobalStreamId(this.producerComponentId, this.producerStreamId);
    }

    @Override
    public String getSourceComponent() {
        return this.producerComponentId;
    }

    @Override
    public int getSourceTask() {
        return this.producerTaskId;
    }

    @Override
    public String getSourceStreamId() {
        return this.producerStreamId;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.messageId == null ? 0 : this.messageId.hashCode());
        result2 = 31 * result2 + (this.producerComponentId == null ? 0 : this.producerComponentId.hashCode());
        result2 = 31 * result2 + (this.producerStreamId == null ? 0 : this.producerStreamId.hashCode());
        result2 = 31 * result2 + this.producerTaskId;
        result2 = 31 * result2 + (this.schema == null ? 0 : this.schema.toList().hashCode());
        result2 = 31 * result2 + (this.stormTuple == null ? 0 : this.stormTuple.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StormTuple other = (StormTuple)obj;
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        if (this.producerComponentId == null ? other.producerComponentId != null : !this.producerComponentId.equals(other.producerComponentId)) {
            return false;
        }
        if (this.producerStreamId == null ? other.producerStreamId != null : !this.producerStreamId.equals(other.producerStreamId)) {
            return false;
        }
        if (this.producerTaskId != other.producerTaskId) {
            return false;
        }
        if (this.schema == null ? other.schema != null : !this.schema.toList().equals(other.schema.toList())) {
            return false;
        }
        return !(this.stormTuple == null ? other.stormTuple != null : !this.stormTuple.equals(other.stormTuple));
    }

    public String toString() {
        return "StormTuple{ " + this.stormTuple.toString() + "[" + this.producerComponentId + "," + this.producerStreamId + "," + this.producerTaskId + "," + this.messageId + "]}";
    }
}

