/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.util;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Values;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.storm.util.FileSpout;
import org.apache.flink.storm.util.FiniteSpout;

public class FiniteFileSpout
extends FileSpout
implements FiniteSpout {
    private static final long serialVersionUID = -1472978008607215864L;
    private String line;
    private boolean newLineRead;

    public FiniteFileSpout() {
    }

    public FiniteFileSpout(String path) {
        super(path);
    }

    @Override
    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        super.open(conf, context, collector);
        this.newLineRead = false;
    }

    @Override
    public void nextTuple() {
        this.collector.emit(new Values(this.line));
        this.newLineRead = false;
    }

    @Override
    public boolean reachedEnd() {
        try {
            this.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occured while reading file " + this.path);
        }
        return this.line == null;
    }

    private void readLine() throws IOException {
        if (!this.newLineRead) {
            this.line = this.reader.readLine();
            this.newLineRead = true;
        }
    }
}

