/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.util;

import backtype.storm.task.TopologyContext;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.storm.util.AbstractBoltSink;
import org.apache.flink.storm.util.OutputFormatter;
import org.apache.flink.storm.util.SimpleOutputFormatter;

public final class BoltFileSink
extends AbstractBoltSink {
    private static final long serialVersionUID = 2014027288631273666L;
    private final String path;
    private BufferedWriter writer;

    public BoltFileSink(String path) {
        this(path, new SimpleOutputFormatter());
    }

    public BoltFileSink(String path, OutputFormatter formatter) {
        super(formatter);
        this.path = path;
    }

    public void prepareSimple(Map stormConf, TopologyContext context) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeExternal(String line) {
        try {
            this.writer.write(line + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

