/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.api;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.MessageId;
import org.apache.flink.storm.wrappers.StormTuple;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.util.Collector;

final class TwoFlinkStreamsMerger<IN1, IN2>
implements CoFlatMapFunction<IN1, IN2, StormTuple> {
    private static final long serialVersionUID = -495174165824062256L;
    private final String inputStreamId1;
    private final String inputComponentId1;
    private final Fields inputSchema1;
    private final String inputStreamId2;
    private final String inputComponentId2;
    private final Fields inputSchema2;

    public TwoFlinkStreamsMerger(GlobalStreamId streamId1, Fields schema1, GlobalStreamId streamId2, Fields schema2) {
        this.inputStreamId1 = streamId1.get_streamId();
        this.inputComponentId1 = streamId1.get_componentId();
        this.inputSchema1 = schema1;
        this.inputStreamId2 = streamId2.get_streamId();
        this.inputComponentId2 = streamId2.get_componentId();
        this.inputSchema2 = schema2;
    }

    public void flatMap1(IN1 value, Collector<StormTuple> out) throws Exception {
        out.collect(new StormTuple<IN1>(value, this.inputSchema1, 0, this.inputStreamId1, this.inputComponentId1, MessageId.makeUnanchored()));
    }

    public void flatMap2(IN2 value, Collector<StormTuple> out) throws Exception {
        out.collect(new StormTuple<IN2>(value, this.inputSchema2, 0, this.inputStreamId2, this.inputComponentId2, MessageId.makeUnanchored()));
    }
}

