/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.ReportedFailedException;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBoltExecutor
implements IRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(BasicBoltExecutor.class);
    private IBasicBolt _bolt;
    private transient BasicOutputCollector _collector;

    public BasicBoltExecutor(IBasicBolt bolt) {
        this._bolt = bolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._bolt.declareOutputFields(declarer);
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this._bolt.prepare(stormConf, context);
        this._collector = new BasicOutputCollector(collector);
    }

    @Override
    public void execute(Tuple input) {
        this._collector.setContext(input);
        try {
            this._bolt.execute(input, this._collector);
            this._collector.getOutputter().ack(input);
        }
        catch (FailedException e) {
            if (e instanceof ReportedFailedException) {
                this._collector.reportError(e);
            }
            this._collector.getOutputter().fail(input);
        }
    }

    @Override
    public void cleanup() {
        this._bolt.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._bolt.getComponentConfiguration();
    }
}

