/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.task;

import backtype.storm.generated.ShellComponent;
import backtype.storm.metric.api.IMetric;
import backtype.storm.metric.api.rpc.IShellMetric;
import backtype.storm.multilang.BoltMsg;
import backtype.storm.multilang.ShellMsg;
import backtype.storm.task.IBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.ReportedFailedException;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.ShellProcess;
import clojure.lang.RT;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.guava.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellBolt
implements IBolt {
    public static final String HEARTBEAT_STREAM_ID = "__heartbeat";
    public static Logger LOG = LoggerFactory.getLogger(ShellBolt.class);
    Process _subprocess;
    OutputCollector _collector;
    Map<String, Tuple> _inputs = new ConcurrentHashMap<String, Tuple>();
    private String[] _command;
    private ShellProcess _process;
    private volatile boolean _running = true;
    private volatile Throwable _exception;
    private LinkedBlockingQueue _pendingWrites = new LinkedBlockingQueue();
    private Random _rand;
    private Thread _readerThread;
    private Thread _writerThread;
    private TopologyContext _context;
    private int workerTimeoutMills;
    private ScheduledExecutorService heartBeatExecutorService;
    private AtomicLong lastHeartbeatTimestamp = new AtomicLong();
    private AtomicBoolean sendHeartbeatFlag = new AtomicBoolean(false);

    public ShellBolt(ShellComponent component) {
        this(component.get_execution_command(), component.get_script());
    }

    public ShellBolt(String ... command) {
        this._command = command;
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        Object maxPending = stormConf.get("topology.shellbolt.max.pending");
        if (maxPending != null) {
            this._pendingWrites = new LinkedBlockingQueue(((Number)maxPending).intValue());
        }
        this._rand = new Random();
        this._collector = collector;
        this._context = context;
        this.workerTimeoutMills = 1000 * RT.intCast(stormConf.get("supervisor.worker.timeout.secs"));
        this._process = new ShellProcess(this._command);
        Number subpid = this._process.launch(stormConf, context);
        LOG.info("Launched subprocess with pid " + subpid);
        this._readerThread = new Thread(new BoltReaderRunnable());
        this._readerThread.start();
        this._writerThread = new Thread(new BoltWriterRunnable());
        this._writerThread.start();
        this.heartBeatExecutorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
        this.heartBeatExecutorService.scheduleAtFixedRate(new BoltHeartbeatTimerTask(this), 1L, 1L, TimeUnit.SECONDS);
        LOG.info("Start checking heartbeat...");
        this.setHeartbeat();
    }

    @Override
    public void execute(Tuple input) {
        if (this._exception != null) {
            throw new RuntimeException(this._exception);
        }
        String genId = Long.toString(this._rand.nextLong());
        this._inputs.put(genId, input);
        try {
            BoltMsg boltMsg = this.createBoltMessage(input, genId);
            this._pendingWrites.put(boltMsg);
        }
        catch (InterruptedException e) {
            String processInfo = this._process.getProcessInfoString() + this._process.getProcessTerminationInfoString();
            throw new RuntimeException("Error during multilang processing " + processInfo, e);
        }
    }

    private BoltMsg createBoltMessage(Tuple input, String genId) {
        BoltMsg boltMsg = new BoltMsg();
        boltMsg.setId(genId);
        boltMsg.setComp(input.getSourceComponent());
        boltMsg.setStream(input.getSourceStreamId());
        boltMsg.setTask((long)input.getSourceTask());
        boltMsg.setTuple(input.getValues());
        return boltMsg;
    }

    @Override
    public void cleanup() {
        this._running = false;
        this.heartBeatExecutorService.shutdownNow();
        this._writerThread.interrupt();
        this._readerThread.interrupt();
        this._process.destroy();
        this._inputs.clear();
    }

    private void handleAck(Object id) {
        Tuple acked = this._inputs.remove(id);
        if (acked == null) {
            throw new RuntimeException("Acked a non-existent or already acked/failed id: " + id);
        }
        this._collector.ack(acked);
    }

    private void handleFail(Object id) {
        Tuple failed = this._inputs.remove(id);
        if (failed == null) {
            throw new RuntimeException("Failed a non-existent or already acked/failed id: " + id);
        }
        this._collector.fail(failed);
    }

    private void handleError(String msg) {
        this._collector.reportError(new Exception("Shell Process Exception: " + msg));
    }

    private void handleEmit(ShellMsg shellMsg) throws InterruptedException {
        ArrayList<Tuple> anchors = new ArrayList<Tuple>();
        List recvAnchors = shellMsg.getAnchors();
        if (recvAnchors != null) {
            for (String anchor : recvAnchors) {
                Tuple t = this._inputs.get(anchor);
                if (t == null) {
                    throw new RuntimeException("Anchored onto " + anchor + " after ack/fail");
                }
                anchors.add(t);
            }
        }
        if (shellMsg.getTask() == 0L) {
            List<Integer> outtasks = this._collector.emit(shellMsg.getStream(), anchors, (List<Object>)shellMsg.getTuple());
            if (shellMsg.areTaskIdsNeeded()) {
                this._pendingWrites.put(outtasks);
            }
        } else {
            this._collector.emitDirect((int)shellMsg.getTask(), shellMsg.getStream(), anchors, (List<Object>)shellMsg.getTuple());
        }
    }

    private void handleLog(ShellMsg shellMsg) {
        String msg = shellMsg.getMsg();
        msg = "ShellLog " + this._process.getProcessInfoString() + " " + msg;
        ShellMsg.ShellLogLevel logLevel = shellMsg.getLogLevel();
        switch (logLevel) {
            case TRACE: {
                LOG.trace(msg);
                break;
            }
            case DEBUG: {
                LOG.debug(msg);
                break;
            }
            case INFO: {
                LOG.info(msg);
                break;
            }
            case WARN: {
                LOG.warn(msg);
                break;
            }
            case ERROR: {
                LOG.error(msg);
                this._collector.reportError(new ReportedFailedException(msg));
                break;
            }
            default: {
                LOG.info(msg);
            }
        }
    }

    private void handleMetrics(ShellMsg shellMsg) {
        String name = shellMsg.getMetricName();
        if (name.isEmpty()) {
            throw new RuntimeException("Receive Metrics name is empty");
        }
        IMetric iMetric = this._context.getRegisteredMetricByName(name);
        if (iMetric == null) {
            throw new RuntimeException("Could not find metric by name[" + name + "] ");
        }
        if (!(iMetric instanceof IShellMetric)) {
            throw new RuntimeException("Metric[" + name + "] is not IShellMetric, can not call by RPC");
        }
        IShellMetric iShellMetric = (IShellMetric)iMetric;
        Object paramsObj = shellMsg.getMetricParams();
        try {
            iShellMetric.updateMetricFromRPC(paramsObj);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setHeartbeat() {
        this.lastHeartbeatTimestamp.set(System.currentTimeMillis());
    }

    private long getLastHeartbeat() {
        return this.lastHeartbeatTimestamp.get();
    }

    private void die(Throwable exception) {
        String processInfo = this._process.getProcessInfoString() + this._process.getProcessTerminationInfoString();
        this._exception = new RuntimeException(processInfo, exception);
        LOG.error("Halting process: ShellBolt died.", exception);
        this._collector.reportError(exception);
        if (this._running || exception instanceof Error) {
            System.exit(11);
        }
    }

    private class BoltWriterRunnable
    implements Runnable {
        private BoltWriterRunnable() {
        }

        @Override
        public void run() {
            while (ShellBolt.this._running) {
                try {
                    Object write;
                    if (ShellBolt.this.sendHeartbeatFlag.get()) {
                        LOG.debug("BOLT - sending heartbeat request to subprocess");
                        String genId = Long.toString(ShellBolt.this._rand.nextLong());
                        ShellBolt.this._process.writeBoltMsg(this.createHeartbeatBoltMessage(genId));
                        ShellBolt.this.sendHeartbeatFlag.compareAndSet(true, false);
                    }
                    if ((write = ShellBolt.this._pendingWrites.poll(1L, TimeUnit.SECONDS)) instanceof BoltMsg) {
                        ShellBolt.this._process.writeBoltMsg((BoltMsg)write);
                        continue;
                    }
                    if (write instanceof List) {
                        ShellBolt.this._process.writeTaskIds((List)write);
                        continue;
                    }
                    if (write == null) continue;
                    throw new RuntimeException("Unknown class type to write: " + write.getClass().getName());
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    ShellBolt.this.die(t);
                }
            }
        }

        private BoltMsg createHeartbeatBoltMessage(String genId) {
            BoltMsg msg = new BoltMsg();
            msg.setId(genId);
            msg.setTask(-1L);
            msg.setStream(ShellBolt.HEARTBEAT_STREAM_ID);
            msg.setTuple(new ArrayList());
            return msg;
        }
    }

    private class BoltReaderRunnable
    implements Runnable {
        private BoltReaderRunnable() {
        }

        @Override
        public void run() {
            while (ShellBolt.this._running) {
                try {
                    ShellMsg shellMsg = ShellBolt.this._process.readShellMsg();
                    String command = shellMsg.getCommand();
                    if (command == null) {
                        throw new IllegalArgumentException("Command not found in bolt message: " + shellMsg);
                    }
                    if (command.equals("sync")) {
                        ShellBolt.this.setHeartbeat();
                        continue;
                    }
                    if (command.equals("ack")) {
                        ShellBolt.this.handleAck(shellMsg.getId());
                        continue;
                    }
                    if (command.equals("fail")) {
                        ShellBolt.this.handleFail(shellMsg.getId());
                        continue;
                    }
                    if (command.equals("error")) {
                        ShellBolt.this.handleError(shellMsg.getMsg());
                        continue;
                    }
                    if (command.equals("log")) {
                        ShellBolt.this.handleLog(shellMsg);
                        continue;
                    }
                    if (command.equals("emit")) {
                        ShellBolt.this.handleEmit(shellMsg);
                        continue;
                    }
                    if (!command.equals("metrics")) continue;
                    ShellBolt.this.handleMetrics(shellMsg);
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    ShellBolt.this.die(t);
                }
            }
        }
    }

    private class BoltHeartbeatTimerTask
    extends TimerTask {
        private ShellBolt bolt;

        public BoltHeartbeatTimerTask(ShellBolt bolt) {
            this.bolt = bolt;
        }

        @Override
        public void run() {
            long currentTimeMillis = System.currentTimeMillis();
            long lastHeartbeat = ShellBolt.this.getLastHeartbeat();
            LOG.debug("BOLT - current time : {}, last heartbeat : {}, worker timeout (ms) : {}", new Object[]{currentTimeMillis, lastHeartbeat, ShellBolt.this.workerTimeoutMills});
            if (currentTimeMillis - lastHeartbeat > (long)ShellBolt.this.workerTimeoutMills) {
                this.bolt.die(new RuntimeException("subprocess heartbeat timeout"));
            }
            ShellBolt.this.sendHeartbeatFlag.compareAndSet(false, true);
        }
    }
}

