/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.metric;

import backtype.storm.metric.api.IMetricsConsumer;
import backtype.storm.task.IBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Tuple;
import java.util.Collection;
import java.util.Map;

public class MetricsConsumerBolt
implements IBolt {
    IMetricsConsumer _metricsConsumer;
    String _consumerClassName;
    OutputCollector _collector;
    Object _registrationArgument;

    public MetricsConsumerBolt(String consumerClassName, Object registrationArgument) {
        this._consumerClassName = consumerClassName;
        this._registrationArgument = registrationArgument;
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        try {
            this._metricsConsumer = (IMetricsConsumer)Class.forName(this._consumerClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate a class listed in config under section topology.metrics.consumer.register with fully qualified name " + this._consumerClassName, e);
        }
        this._metricsConsumer.prepare(stormConf, this._registrationArgument, context, collector);
        this._collector = collector;
    }

    @Override
    public void execute(Tuple input) {
        this._metricsConsumer.handleDataPoints((IMetricsConsumer.TaskInfo)input.getValue(0), (Collection)input.getValue(1));
        this._collector.ack(input);
    }

    @Override
    public void cleanup() {
        this._metricsConsumer.cleanup();
    }
}

