/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.wrappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.storm.util.SplitStreamType;

abstract class AbstractStormCollector<OUT> {
    protected final HashMap<String, Tuple> outputTuple = new HashMap();
    private final SplitStreamType<Object> splitTuple = new SplitStreamType();
    protected final HashMap<String, Integer> numberOfAttributes;
    private final boolean split;
    private final int taskId;
    boolean tupleEmitted = false;

    AbstractStormCollector(HashMap<String, Integer> numberOfAttributes, int taskId) throws UnsupportedOperationException {
        assert (numberOfAttributes != null);
        this.numberOfAttributes = numberOfAttributes;
        this.split = this.numberOfAttributes.size() > 1;
        this.taskId = taskId;
        for (Map.Entry<String, Integer> outputStream : numberOfAttributes.entrySet()) {
            int numAtt = outputStream.getValue();
            if (this.taskId >= 0) {
                if (numAtt < 0) {
                    throw new UnsupportedOperationException("Task ID transmission not supported for raw streams: " + outputStream.getKey());
                }
                ++numAtt;
            }
            if (numAtt > 25) {
                if (this.taskId >= 0) {
                    throw new UnsupportedOperationException("Flink cannot handle more then 25 attributes, but 25 (24 plus 1 for produer task ID)  are declared for stream '" + outputStream.getKey() + "' by the given bolt.");
                }
                throw new UnsupportedOperationException("Flink cannot handle more then 25 attributes, but " + numAtt + " are declared for stream '" + outputStream.getKey() + "' by the given bolt.");
            }
            if (numAtt < 0) continue;
            try {
                this.outputTuple.put(outputStream.getKey(), (Tuple)Tuple.getTupleClass((int)numAtt).newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final List<Integer> tansformAndEmit(String streamId, List<Object> tuple) {
        List<Integer> taskIds;
        int numAtt;
        int taskIdIdx = numAtt = this.numberOfAttributes.get(streamId).intValue();
        if (this.taskId >= 0 && numAtt < 0) {
            numAtt = 1;
            taskIdIdx = 0;
        }
        if (numAtt >= 0) {
            assert (tuple.size() == numAtt);
            Tuple out = this.outputTuple.get(streamId);
            for (int i = 0; i < numAtt; ++i) {
                out.setField(tuple.get(i), i);
            }
            if (this.taskId >= 0) {
                out.setField((Object)this.taskId, taskIdIdx);
            }
            if (this.split) {
                this.splitTuple.streamId = streamId;
                this.splitTuple.value = out;
                taskIds = this.doEmit(this.splitTuple);
            } else {
                taskIds = this.doEmit(out);
            }
        } else {
            assert (tuple.size() == 1);
            if (this.split) {
                this.splitTuple.streamId = streamId;
                this.splitTuple.value = tuple.get(0);
                taskIds = this.doEmit(this.splitTuple);
            } else {
                taskIds = this.doEmit(tuple.get(0));
            }
        }
        this.tupleEmitted = true;
        return taskIds;
    }

    protected abstract List<Integer> doEmit(OUT var1);
}

