/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.api;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.MessageId;
import org.apache.flink.storm.wrappers.StormTuple;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.util.Collector;

final class StormFlinkStreamMerger<IN1, IN2>
implements CoFlatMapFunction<StormTuple<IN1>, IN2, StormTuple> {
    private static final long serialVersionUID = -914164633830563631L;
    private final String inputStreamId;
    private final String inputComponentId;
    private final Fields inputSchema;

    public StormFlinkStreamMerger(GlobalStreamId streamId, Fields schema) {
        this.inputStreamId = streamId.get_streamId();
        this.inputComponentId = streamId.get_componentId();
        this.inputSchema = schema;
    }

    public void flatMap1(StormTuple<IN1> value, Collector<StormTuple> out) throws Exception {
        out.collect(value);
    }

    public void flatMap2(IN2 value, Collector<StormTuple> out) throws Exception {
        out.collect(new StormTuple<IN2>(value, this.inputSchema, 0, this.inputStreamId, this.inputComponentId, MessageId.makeUnanchored()));
    }
}

