/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.tests;

import backtype.storm.Config;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.tuple.Fields;
import java.util.Map;
import org.apache.flink.storm.api.FlinkLocalCluster;
import org.apache.flink.storm.api.FlinkTopology;
import org.apache.flink.storm.tests.operators.FiniteRandomSpout;
import org.apache.flink.storm.tests.operators.TaskIdBolt;
import org.apache.flink.storm.util.BoltFileSink;
import org.apache.flink.streaming.util.StreamingProgramTestBase;

public class StormFieldsGroupingITCase
extends StreamingProgramTestBase {
    private static final String topologyId = "FieldsGrouping Test";
    private static final String spoutId = "spout";
    private static final String boltId = "bolt";
    private static final String sinkId = "sink";
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void postSubmit() throws Exception {
        StormFieldsGroupingITCase.compareResultsByLinesInMemory((String)"3> -1155484576\n3> 1033096058\n3> -1930858313\n3> 1431162155\n4> -1557280266\n4> -1728529858\n4> 1654374947\n4> -65105105\n4> -518907128\n4> -252332814\n", (String)this.resultPath);
    }

    protected void testProgram() throws Exception {
        String[] tokens = this.resultPath.split(":");
        String outputFile = tokens[tokens.length - 1];
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(spoutId, (IRichSpout)new FiniteRandomSpout(0L, 10, 2));
        builder.setBolt(boltId, (IRichBolt)new TaskIdBolt(), (Number)2).fieldsGrouping(spoutId, "stream_0", new Fields(new String[]{"number"}));
        builder.setBolt(sinkId, (IRichBolt)new BoltFileSink(outputFile)).shuffleGrouping(boltId);
        FlinkLocalCluster cluster = FlinkLocalCluster.getLocalCluster();
        Config conf = new Config();
        conf.put((Object)"SUBMIT_STORM_TOPOLOGY_BLOCKING", (Object)true);
        cluster.submitTopology(topologyId, (Map)conf, FlinkTopology.createTopology((TopologyBuilder)builder));
        cluster.shutdown();
    }
}

