/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.split;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;

public class SplitBolt
extends BaseRichBolt {
    private static final long serialVersionUID = -6627606934204267173L;
    public static final String EVEN_STREAM = "even";
    public static final String ODD_STREAM = "odd";
    private OutputCollector collector;

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
    }

    public void execute(Tuple input) {
        if (input.getInteger(0) % 2 == 0) {
            this.collector.emit(EVEN_STREAM, (List)new Values(new Object[]{input.getInteger(0)}));
        } else {
            this.collector.emit(ODD_STREAM, (List)new Values(new Object[]{input.getInteger(0)}));
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        Fields schema = new Fields(new String[]{"number"});
        declarer.declareStream(EVEN_STREAM, schema);
        declarer.declareStream(ODD_STREAM, schema);
    }
}

