/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.tests.operators;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.storm.util.FiniteSpout;

public class FiniteRandomSpout
extends BaseRichSpout
implements FiniteSpout {
    private static final long serialVersionUID = 6592885571932363239L;
    public static final String STREAM_PREFIX = "stream_";
    private final Random r;
    private SpoutOutputCollector collector;
    private int counter;
    private final String[] outputStreams;

    public FiniteRandomSpout(long seed, int counter, int numberOfOutputStreams) {
        this.r = new Random(seed);
        this.counter = counter;
        if (numberOfOutputStreams < 1) {
            this.outputStreams = new String[]{"default"};
        } else {
            this.outputStreams = new String[numberOfOutputStreams];
            for (int i = 0; i < this.outputStreams.length; ++i) {
                this.outputStreams[i] = STREAM_PREFIX + i;
            }
        }
    }

    public FiniteRandomSpout(long seed, int counter) {
        this(seed, counter, 1);
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
    }

    public void nextTuple() {
        for (String s : this.outputStreams) {
            this.collector.emit(s, (List)new Values(new Object[]{this.r.nextInt()}));
        }
        --this.counter;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String s : this.outputStreams) {
            declarer.declareStream(s, new Fields(new String[]{"number"}));
        }
    }

    public boolean reachedEnd() {
        return this.counter <= 0;
    }
}

