/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.tests;

import backtype.storm.Config;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import java.util.Map;
import org.apache.flink.storm.api.FlinkLocalCluster;
import org.apache.flink.storm.api.FlinkTopology;
import org.apache.flink.storm.tests.operators.FiniteRandomSpout;
import org.apache.flink.storm.tests.operators.MergerBolt;
import org.apache.flink.storm.util.BoltFileSink;
import org.apache.flink.streaming.util.StreamingProgramTestBase;

public class StormUnionITCase
extends StreamingProgramTestBase {
    private static final String RESULT = "-1154715079\n-1155869325\n-1155484576\n431529176\n1260042744\n1761283695\n1749940626\n892128508\n155629808\n1429008869\n-1465154083\n-723955400\n-423279216\n17850135\n2133836778\n1033096058\n-1690734402\n-1557280266\n1327362106\n-1930858313\n502539523\n-1728529858\n-938301587\n-624140595\n-60658084\n142959438\n-613647601\n-330177159\n-54027108\n1945002173\n979930868";
    private static final String topologyId = "Multiple Input Streams Test";
    private static final String spoutId1 = "spout1";
    private static final String spoutId2 = "spout2";
    private static final String spoutId3 = "spout3";
    private static final String boltId = "merger";
    private static final String sinkId = "sink";
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void postSubmit() throws Exception {
        StormUnionITCase.compareResultsByLinesInMemory((String)RESULT, (String)this.resultPath);
    }

    protected void testProgram() throws Exception {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(spoutId1, (IRichSpout)new FiniteRandomSpout(0L, 10));
        builder.setSpout(spoutId2, (IRichSpout)new FiniteRandomSpout(1L, 8));
        builder.setSpout(spoutId3, (IRichSpout)new FiniteRandomSpout(2L, 13));
        ((BoltDeclarer)((BoltDeclarer)builder.setBolt(boltId, (IRichBolt)new MergerBolt()).shuffleGrouping(spoutId1, "stream_0")).shuffleGrouping(spoutId2, "stream_0")).shuffleGrouping(spoutId3, "stream_0");
        String[] tokens = this.resultPath.split(":");
        String outputFile = tokens[tokens.length - 1];
        builder.setBolt(sinkId, (IRichBolt)new BoltFileSink(outputFile)).shuffleGrouping(boltId);
        FlinkLocalCluster cluster = FlinkLocalCluster.getLocalCluster();
        Config conf = new Config();
        conf.put((Object)"SUBMIT_STORM_TOPOLOGY_BLOCKING", (Object)true);
        cluster.submitTopology(topologyId, (Map)conf, FlinkTopology.createTopology((TopologyBuilder)builder));
        cluster.shutdown();
    }
}

