/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.split;

import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import org.apache.flink.storm.split.operators.RandomSpout;
import org.apache.flink.storm.split.operators.VerifyAndEnrichBolt;
import org.apache.flink.storm.util.BoltFileSink;
import org.apache.flink.storm.util.BoltPrintSink;
import org.apache.flink.storm.util.OutputFormatter;
import org.apache.flink.storm.util.TupleOutputFormatter;

public class SplitSpoutTopology {
    public static final String spoutId = "randomSplitSource";
    public static final String evenVerifierId = "evenVerifier";
    public static final String oddVerifierId = "oddVerifier";
    public static final String sinkId = "sink";
    private static final OutputFormatter formatter = new TupleOutputFormatter();
    private static long seed = System.currentTimeMillis();
    private static String outputPath = null;

    public static TopologyBuilder buildTopology() {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(spoutId, (IRichSpout)new RandomSpout(true, seed));
        builder.setBolt(evenVerifierId, (IRichBolt)new VerifyAndEnrichBolt(true)).shuffleGrouping(spoutId, "even");
        builder.setBolt(oddVerifierId, (IRichBolt)new VerifyAndEnrichBolt(false)).shuffleGrouping(spoutId, "odd");
        if (outputPath != null) {
            String[] tokens = outputPath.split(":");
            String outputFile = tokens[tokens.length - 1];
            ((BoltDeclarer)builder.setBolt(sinkId, (IRichBolt)new BoltFileSink(outputFile, formatter)).shuffleGrouping(evenVerifierId)).shuffleGrouping(oddVerifierId);
        } else {
            ((BoltDeclarer)builder.setBolt(sinkId, (IRichBolt)new BoltPrintSink(formatter), (Number)4).shuffleGrouping(evenVerifierId)).shuffleGrouping(oddVerifierId);
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing SplitSpoutTopology example with random data");
            System.out.println("  Usage: SplitStreamSpoutLocal <seed> <result path>");
            return true;
        }
        if (args.length == 2) {
            seed = Long.parseLong(args[0]);
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: SplitStreamSpoutLocal <seed> <result path>");
        return false;
    }
}

