/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.wordcount;

import backtype.storm.topology.IRichSpout;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.storm.wordcount.operators.WordCountFileSpout;
import org.apache.flink.storm.wordcount.operators.WordCountInMemorySpout;
import org.apache.flink.storm.wrappers.SpoutWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.Collector;

public class SpoutSourceWordCount {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!SpoutSourceWordCount.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStream<String> text = SpoutSourceWordCount.getTextDataStream(env);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).keyBy(new int[]{0}).sum(1);
        if (fileOutput) {
            counts.writeAsText(outputPath);
        } else {
            counts.print();
        }
        env.execute("Streaming WordCount with spout source");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing SpoutSourceWordCount example with built-in default data");
            System.out.println("  Provide parameters to read input data from a file");
            System.out.println("  Usage: SpoutSourceWordCount <text path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            textPath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: SpoutSourceWordCount <text path> <result path>");
        return false;
    }

    private static DataStream<String> getTextDataStream(StreamExecutionEnvironment env) {
        if (fileOutput) {
            String[] tokens = textPath.split(":");
            String localFile = tokens[tokens.length - 1];
            return env.addSource(new SpoutWrapper((IRichSpout)new WordCountFileSpout(localFile), new String[]{"default"}, (Integer)-1), TypeExtractor.getForClass(String.class)).setParallelism(1);
        }
        return env.addSource(new SpoutWrapper((IRichSpout)new WordCountInMemorySpout(), new String[]{"default"}, (Integer)-1), TypeExtractor.getForClass(String.class)).setParallelism(1);
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) throws Exception {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

