/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.tests;

import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.utils.Utils;
import org.apache.flink.storm.api.FlinkLocalCluster;
import org.apache.flink.storm.api.FlinkTopology;
import org.apache.flink.storm.tests.operators.MetaDataSpout;
import org.apache.flink.storm.tests.operators.VerifyMetaDataBolt;
import org.apache.flink.streaming.util.StreamingProgramTestBase;
import org.junit.Assert;

public class StormMetaDataITCase
extends StreamingProgramTestBase {
    private static final String topologyId = "FieldsGrouping Test";
    private static final String spoutId = "spout";
    private static final String boltId1 = "bolt1";
    private static final String boltId2 = "bolt2";

    protected void testProgram() throws Exception {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(spoutId, (IRichSpout)new MetaDataSpout(), (Number)2);
        builder.setBolt(boltId1, (IRichBolt)new VerifyMetaDataBolt(), (Number)2).localOrShuffleGrouping(spoutId, "spoutMeta");
        builder.setBolt(boltId2, (IRichBolt)new VerifyMetaDataBolt()).shuffleGrouping(boltId1, "boltMeta");
        FlinkLocalCluster cluster = FlinkLocalCluster.getLocalCluster();
        cluster.submitTopology(topologyId, null, FlinkTopology.createTopology((TopologyBuilder)builder));
        Utils.sleep((long)5000L);
        cluster.shutdown();
        Assert.assertFalse((boolean)VerifyMetaDataBolt.errorOccured);
    }
}

