/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.wordcount.operators;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.Map;

public final class BoltTokenizer
implements IRichBolt {
    private static final long serialVersionUID = -8589620297208175149L;
    public static final String ATTRIBUTE_WORD = "word";
    public static final String ATTRIBUTE_COUNT = "count";
    public static final int ATTRIBUTE_WORD_INDEX = 0;
    public static final int ATTRIBUTE_COUNT_INDEX = 1;
    private OutputCollector collector;

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
    }

    @Override
    public void execute(Tuple input) {
        String[] tokens;
        for (String token : tokens = input.getString(0).toLowerCase().split("\\W+")) {
            if (token.length() <= 0) continue;
            this.collector.emit(new Values(token, 1));
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(ATTRIBUTE_WORD, ATTRIBUTE_COUNT));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

