/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.util;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Values;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.storm.util.AbstractLineSpout;

public class FileSpout
extends AbstractLineSpout {
    private static final long serialVersionUID = -6996907090003590436L;
    public static final String INPUT_FILE_PATH = "input.path";
    protected String path = null;
    protected BufferedReader reader;

    public FileSpout() {
    }

    public FileSpout(String path) {
        this.path = path;
    }

    @Override
    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        super.open(conf, context, collector);
        Object configuredPath = conf.get(INPUT_FILE_PATH);
        if (configuredPath != null) {
            this.path = (String)configuredPath;
        }
        try {
            this.reader = new BufferedReader(new FileReader(this.path));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void nextTuple() {
        try {
            String line = this.reader.readLine();
            if (line != null) {
                this.collector.emit(new Values(line));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

