/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.util;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import org.apache.flink.storm.util.OutputFormatter;

public abstract class AbstractBoltSink
implements IRichBolt {
    private static final long serialVersionUID = -1626323806848080430L;
    private StringBuilder lineBuilder;
    private String prefix = "";
    private final OutputFormatter formatter;

    public AbstractBoltSink(OutputFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public final void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.prepareSimple(stormConf, context);
        if (context.getComponentCommon(context.getThisComponentId()).get_parallelism_hint() > 1) {
            this.prefix = context.getThisTaskId() + "> ";
        }
    }

    protected abstract void prepareSimple(Map<?, ?> var1, TopologyContext var2);

    @Override
    public final void execute(Tuple input) {
        this.lineBuilder = new StringBuilder();
        this.lineBuilder.append(this.prefix);
        this.lineBuilder.append(this.formatter.format(input));
        this.writeExternal(this.lineBuilder.toString());
    }

    protected abstract void writeExternal(String var1);

    @Override
    public void cleanup() {
    }

    @Override
    public final void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

