/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.storm.api;

import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;

final class FlinkOutputFieldsDeclarer
implements OutputFieldsDeclarer {
    final HashMap<String, Fields> outputStreams = new HashMap();

    FlinkOutputFieldsDeclarer() {
    }

    @Override
    public void declare(Fields fields) {
        this.declareStream("default", false, fields);
    }

    @Override
    public void declare(boolean direct, Fields fields) {
        this.declareStream("default", direct, fields);
    }

    @Override
    public void declareStream(String streamId, Fields fields) {
        this.declareStream(streamId, false, fields);
    }

    @Override
    public void declareStream(String streamId, boolean direct, Fields fields) {
        if (direct) {
            throw new UnsupportedOperationException("Direct emit is not supported by Flink");
        }
        this.outputStreams.put(streamId, fields);
    }

    TypeInformation<Tuple> getOutputType(String streamId) throws IllegalArgumentException {
        Tuple t;
        if (streamId == null) {
            return null;
        }
        Fields outputSchema = this.outputStreams.get(streamId);
        if (outputSchema == null) {
            throw new IllegalArgumentException("Stream with ID '" + streamId + "' was not declared.");
        }
        int numberOfAttributes = outputSchema.size();
        if (numberOfAttributes <= 24) {
            try {
                t = (Tuple)Tuple.getTupleClass((int)(numberOfAttributes + 1)).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Flink supports only a maximum number of 24 attributes");
        }
        for (int i = 0; i < numberOfAttributes + 1; ++i) {
            t.setField((Object)new DefaultComparable(), i);
        }
        return TypeExtractor.getForObject((Object)t);
    }

    int[] getGroupingFieldIndexes(String streamId, List<String> groupingFields) {
        int[] fieldIndexes = new int[groupingFields.size()];
        for (int i = 0; i < fieldIndexes.length; ++i) {
            fieldIndexes[i] = this.outputStreams.get(streamId).fieldIndex(groupingFields.get(i));
        }
        return fieldIndexes;
    }

    private static class DefaultComparable
    implements Comparable<DefaultComparable> {
        @Override
        public int compareTo(DefaultComparable o) {
            return 0;
        }
    }
}

