/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.internal.InternalAppendingState;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

abstract class AbstractRocksDBAppendingState<K, N, IN, SV, OUT>
extends AbstractRocksDBState<K, N, SV>
implements InternalAppendingState<K, N, IN, SV, OUT> {
    protected AbstractRocksDBAppendingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> valueSerializer, SV defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
    }

    public SV getInternal() {
        return this.getInternal(this.getKeyBytes());
    }

    SV getInternal(byte[] key) {
        try {
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            this.dataInputView.setBuffer(valueBytes);
            return (SV)this.valueSerializer.deserialize((DataInputView)this.dataInputView);
        }
        catch (IOException | RocksDBException e) {
            throw new FlinkRuntimeException("Error while retrieving data from RocksDB", e);
        }
    }

    public void updateInternal(SV valueToStore) {
        this.updateInternal(this.getKeyBytes(), valueToStore);
    }

    void updateInternal(byte[] key, SV valueToStore) {
        try {
            this.backend.db.put(this.columnFamily, this.writeOptions, key, this.getValueBytes(valueToStore));
        }
        catch (RocksDBException e) {
            throw new FlinkRuntimeException("Error while adding value to RocksDB", (Throwable)e);
        }
    }
}

