/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksDBValueState<K, N, V>
extends AbstractRocksDBState<K, N, ValueState<V>, ValueStateDescriptor<V>>
implements ValueState<V> {
    private final TypeSerializer<V> valueSerializer;
    private final ValueStateDescriptor<V> stateDesc;
    private final WriteOptions writeOptions;

    public RocksDBValueState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc, RocksDBStateBackend backend) {
        super(columnFamily, namespaceSerializer, backend);
        this.stateDesc = Objects.requireNonNull(stateDesc);
        this.valueSerializer = stateDesc.getSerializer();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setDisableWAL(true);
    }

    public V value() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return (V)this.stateDesc.getDefaultValue();
            }
            return (V)this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(valueBytes)));
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Error while retrieving data from RocksDB.", e);
        }
    }

    public void update(V value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            baos.reset();
            this.valueSerializer.serialize(value, (DataOutputView)out);
            this.backend.db.put(this.columnFamily, this.writeOptions, key, baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding data to RocksDB", e);
        }
    }
}

