/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksDBListState<K, N, V>
extends AbstractRocksDBState<K, N, ListState<V>, ListStateDescriptor<V>>
implements ListState<V> {
    private final TypeSerializer<V> valueSerializer;
    private final ListStateDescriptor<V> stateDesc;
    private final WriteOptions writeOptions;

    public RocksDBListState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, ListStateDescriptor<V> stateDesc, RocksDBStateBackend backend) {
        super(columnFamily, namespaceSerializer, backend);
        this.stateDesc = Objects.requireNonNull(stateDesc);
        this.valueSerializer = stateDesc.getSerializer();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setDisableWAL(true);
    }

    public Iterable<V> get() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(valueBytes);
            DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)bais);
            ArrayList<Object> result = new ArrayList<Object>();
            while (in.available() > 0) {
                result.add(this.valueSerializer.deserialize((DataInputView)in));
                if (in.available() <= 0) continue;
                in.readByte();
            }
            return result;
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Error while retrieving data from RocksDB", e);
        }
    }

    public void add(V value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            baos.reset();
            this.valueSerializer.serialize(value, (DataOutputView)out);
            this.backend.db.merge(this.columnFamily, this.writeOptions, key, baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding data to RocksDB", e);
        }
    }
}

