/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksDBFoldingState<K, N, T, ACC>
extends AbstractRocksDBState<K, N, FoldingState<T, ACC>, FoldingStateDescriptor<T, ACC>>
implements FoldingState<T, ACC> {
    private final TypeSerializer<ACC> valueSerializer;
    private final FoldingStateDescriptor<T, ACC> stateDesc;
    private final FoldFunction<T, ACC> foldFunction;
    private final WriteOptions writeOptions;

    public RocksDBFoldingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, FoldingStateDescriptor<T, ACC> stateDesc, RocksDBStateBackend backend) {
        super(columnFamily, namespaceSerializer, backend);
        this.stateDesc = Objects.requireNonNull(stateDesc);
        this.valueSerializer = stateDesc.getSerializer();
        this.foldFunction = stateDesc.getFoldFunction();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setDisableWAL(true);
    }

    public ACC get() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            return (ACC)this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(valueBytes)));
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Error while retrieving data from RocksDB", e);
        }
    }

    public void add(T value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                baos.reset();
                this.valueSerializer.serialize(this.foldFunction.fold(this.stateDesc.getDefaultValue(), value), (DataOutputView)out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, baos.toByteArray());
            } else {
                Object oldValue = this.valueSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(valueBytes)));
                Object newValue = this.foldFunction.fold(oldValue, value);
                baos.reset();
                this.valueSerializer.serialize(newValue, (DataOutputView)out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, baos.toByteArray());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding data to RocksDB", e);
        }
    }
}

