/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocksDBState<K, N, S extends State, SD extends StateDescriptor<S, ?>>
implements KvState<K, N, S, SD, RocksDBStateBackend>,
State {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRocksDBState.class);
    private final TypeSerializer<N> namespaceSerializer;
    private N currentNamespace;
    protected RocksDBStateBackend backend;
    protected ColumnFamilyHandle columnFamily;
    private final WriteOptions writeOptions;

    protected AbstractRocksDBState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, RocksDBStateBackend backend) {
        this.namespaceSerializer = namespaceSerializer;
        this.backend = backend;
        this.columnFamily = columnFamily;
        this.writeOptions = new WriteOptions();
        this.writeOptions.setDisableWAL(true);
    }

    public void clear() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.writeKeyAndNamespace((DataOutputView)out);
            byte[] key = baos.toByteArray();
            this.backend.db.remove(this.columnFamily, this.writeOptions, key);
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Error while removing entry from RocksDB", e);
        }
    }

    protected void writeKeyAndNamespace(DataOutputView out) throws IOException {
        this.backend.keySerializer().serialize(this.backend.currentKey(), out);
        out.writeByte(42);
        this.namespaceSerializer.serialize(this.currentNamespace, out);
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = namespace;
    }

    public void dispose() {
    }

    public void setCurrentKey(K key) {
    }

    public KvStateSnapshot<K, N, S, SD, RocksDBStateBackend> snapshot(long checkpointId, long timestamp) throws Exception {
        throw new RuntimeException("Should not be called. Backups happen in RocksDBStateBackend.");
    }
}

