/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.delegate.DelegatingStateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.state.changelog.ChangelogKeyedStateBackend;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogStateBackend
implements DelegatingStateBackend,
ConfigurableStateBackend {
    private static final long serialVersionUID = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogStateBackend.class);
    private final StateBackend delegatedStateBackend;

    public ChangelogStateBackend(StateBackend stateBackend) {
        this.delegatedStateBackend = (StateBackend)Preconditions.checkNotNull((Object)stateBackend);
        Preconditions.checkArgument((!(stateBackend instanceof DelegatingStateBackend) ? 1 : 0) != 0, (Object)"Recursive Delegation is not supported.");
        LOG.info("ChangelogStateBackend is used, delegating {}.", (Object)this.delegatedStateBackend.getClass().getSimpleName());
    }

    public <K> ChangelogKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
        AbstractKeyedStateBackend keyedStateBackend = (AbstractKeyedStateBackend)this.delegatedStateBackend.createKeyedStateBackend(env, jobID, operatorIdentifier, keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, ttlTimeProvider, metricGroup, stateHandles, cancelStreamRegistry);
        return new ChangelogKeyedStateBackend(keyedStateBackend, env.getExecutionConfig(), ttlTimeProvider);
    }

    public <K> CheckpointableKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry, double managedMemoryFraction) throws Exception {
        AbstractKeyedStateBackend keyedStateBackend = (AbstractKeyedStateBackend)this.delegatedStateBackend.createKeyedStateBackend(env, jobID, operatorIdentifier, keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, ttlTimeProvider, metricGroup, stateHandles, cancelStreamRegistry, managedMemoryFraction);
        return new ChangelogKeyedStateBackend(keyedStateBackend, env.getExecutionConfig(), ttlTimeProvider);
    }

    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
        return this.delegatedStateBackend.createOperatorStateBackend(env, operatorIdentifier, stateHandles, cancelStreamRegistry);
    }

    public boolean useManagedMemory() {
        return this.delegatedStateBackend.useManagedMemory();
    }

    public StateBackend getDelegatedStateBackend() {
        return this.delegatedStateBackend;
    }

    public StateBackend configure(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException {
        if (this.delegatedStateBackend instanceof ConfigurableStateBackend) {
            return new ChangelogStateBackend(((ConfigurableStateBackend)this.delegatedStateBackend).configure(config, classLoader));
        }
        return this;
    }
}

