/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;

class ReducingStateChangeApplier<K, N, T>
extends KvStateChangeApplier<K, N> {
    private final InternalReducingState<K, N, T> state;

    protected ReducingStateChangeApplier(InternalKeyContext<K> keyContext, InternalReducingState<K, N, T> state) {
        super(keyContext);
        this.state = state;
    }

    @Override
    protected InternalKvState<K, N, ?> getState() {
        return this.state;
    }

    @Override
    protected void applyInternal(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case SET: 
            case SET_INTERNAL: {
                this.state.updateInternal(this.state.getValueSerializer().deserialize(in));
                break;
            }
            case CLEAR: {
                this.state.clear();
                break;
            }
            case MERGE_NS: {
                ReducingStateChangeApplier.applyMergeNamespaces(this.state, in);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state change operation: " + (Object)((Object)operation));
            }
        }
    }
}

